/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyGlobalPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobal;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobalObject;
import com.oracle.truffle.js.runtime.builtins.wasm.WebAssemblyValueType;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class WebAssemblyGlobalPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WebAssemblyGlobalPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WebAssemblyGlobalPrototypeBuiltins();

    protected WebAssemblyGlobalPrototypeBuiltins() {
        super(JSWebAssemblyGlobal.PROTOTYPE_NAME, WebAssemblyGlobalPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WebAssemblyGlobalPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: {
                return WebAssemblyGlobalPrototypeBuiltinsFactory.WebAssemblyGlobalGetValueNodeGen.create(context, builtin, WebAssemblyGlobalPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 2: {
                return WebAssemblyGlobalPrototypeBuiltinsFactory.WebAssemblyGlobalSetValueNodeGen.create(context, builtin, WebAssemblyGlobalPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum WebAssemblyGlobalPrototype implements BuiltinEnum<WebAssemblyGlobalPrototype>
    {
        valueOf(0),
        value(0){

            @Override
            public boolean isGetter() {
                return true;
            }
        }
        ,
        set_value(1){

            @Override
            public Object getKey() {
                return value.getKey();
            }

            @Override
            public boolean isSetter() {
                return true;
            }
        };

        private final int length;

        private WebAssemblyGlobalPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isEnumerable() {
            return true;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WebAssemblyGlobalGetValueNode
    extends JSBuiltinNode {
        protected WebAssemblyGlobalGetValueNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getValue(JSWebAssemblyGlobalObject object, @Cached InlinedBranchProfile errorBranch, @Cached ToJSValueNode toJSValueNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary globalReadLib) {
            if (object.getValueType() == WebAssemblyValueType.v128) {
                errorBranch.enter((Node)this);
                this.v128TypeError();
            }
            Object wasmGlobal = object.getWASMGlobal();
            Object globalRead = this.getRealm().getWASMGlobalRead();
            try {
                return toJSValueNode.execute(globalReadLib.execute(globalRead, new Object[]{wasmGlobal}));
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        protected Object doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeError(String.valueOf(this.getBuiltin().getFullName()) + ": Receiver is not a WebAssembly.Global", (Node)this);
        }

        @CompilerDirectives.TruffleBoundary
        private void v128TypeError() {
            throw Errors.createTypeError(String.valueOf(this.getBuiltin().getFullName()) + ": cannot read value type v128", (Node)this);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WebAssemblyGlobalSetValueNode
    extends JSBuiltinNode {
        protected WebAssemblyGlobalSetValueNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object setValue(JSWebAssemblyGlobalObject global, Object[] args, @Cached InlinedBranchProfile errorBranch, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary globalWriteLib) {
            if (!global.isMutable()) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("set WebAssembly.Global.value: Can't set the value of an immutable global");
            }
            if (global.getValueType() == WebAssemblyValueType.v128) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("set WebAssembly.Global.value: cannot write value type v128", (Node)this);
            }
            Object wasmGlobal = global.getWASMGlobal();
            try {
                if (args.length == 0) {
                    errorBranch.enter((Node)this);
                    throw Errors.createTypeError("set WebAssembly.Global.value: Argument 0 is required");
                }
                Object value = args[0];
                Object webAssemblyValue = toWebAssemblyValueNode.execute(value, global.getValueType());
                Object globalWrite = this.getRealm().getWASMGlobalWrite();
                globalWriteLib.execute(globalWrite, new Object[]{wasmGlobal, webAssemblyValue});
                return Undefined.instance;
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (AbstractTruffleException ex) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError(ex, (Node)this);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        protected Object doIncompatibleReceiver(Object thisObj, Object args) {
            throw Errors.createTypeError("set WebAssembly.Global.value: Receiver is not a WebAssembly.Global", (Node)this);
        }
    }
}

