/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.regex.RegexOptionsOptionDescriptors;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.flavor.java.JavaFlavorProvider;
import com.oracle.truffle.regex.flavor.js.JSFlavorProvider;
import com.oracle.truffle.regex.flavor.oracledb.OracleDBFlavorProvider;
import com.oracle.truffle.regex.flavor.python.PythonFlavorProvider;
import com.oracle.truffle.regex.flavor.ruby.RubyFlavorProvider;
import com.oracle.truffle.regex.tregex.parser.MatchingMode;
import com.oracle.truffle.regex.tregex.parser.RegexFlavor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.Arrays;
import java.util.Objects;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;

@Option.Group(value={"regex"})
public final class RegexOptions {
    private static final int U180E_WHITESPACE = 1;
    public static final String U180E_WHITESPACE_NAME = "U180EWhitespace";
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Treat 0x180E MONGOLIAN VOWEL SEPARATOR as white space. Applies to ECMAScriptFlavor only.")
    public static final OptionKey<Boolean> U180EWhitespace = new OptionKey((Object)false);
    private static final int REGRESSION_TEST_MODE = 2;
    public static final String REGRESSION_TEST_MODE_NAME = "RegressionTestMode";
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Enable regression test mode. For internal testing only.")
    public static final OptionKey<Boolean> RegressionTestMode = new OptionKey((Object)false);
    private static final int DUMP_AUTOMATA = 4;
    public static final String DUMP_AUTOMATA_NAME = "DumpAutomata";
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Dump generated automata to disk. For internal testing only.")
    public static final OptionKey<Boolean> DumpAutomata = new OptionKey((Object)false);
    private static final int STEP_EXECUTION = 8;
    public static final String STEP_EXECUTION_NAME = "StepExecution";
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Dump automata execution traces to disk. For internal testing only.")
    public static final OptionKey<Boolean> DumpAutomataExecution = new OptionKey((Object)false);
    private static final int ALWAYS_EAGER = 16;
    public static final String ALWAYS_EAGER_NAME = "AlwaysEager";
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, help="Force eager capture group tracking.")
    public static final OptionKey<Boolean> AlwaysEager = new OptionKey((Object)false);
    private static final int UTF_16_EXPLODE_ASTRAL_SYMBOLS = 32;
    public static final String UTF_16_EXPLODE_ASTRAL_SYMBOLS_NAME = "UTF16ExplodeAstralSymbols";
    private static final int VALIDATE = 64;
    public static final String VALIDATE_NAME = "Validate";
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Don't generate a regex matcher, just check for syntax errors.")
    public static final OptionKey<Boolean> Validate = new OptionKey((Object)false);
    private static final int IGNORE_ATOMIC_GROUPS = 128;
    public static final String IGNORE_ATOMIC_GROUPS_NAME = "IgnoreAtomicGroups";
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Treat atomic groups the same as regular groups.")
    public static final OptionKey<Boolean> IgnoreAtomicGroups = new OptionKey((Object)false);
    private static final int GENERATE_DFA_IMMEDIATELY = 256;
    private static final String GENERATE_DFA_IMMEDIATELY_NAME = "GenerateDFAImmediately";
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Disable lazy DFA generation.")
    public static final OptionKey<Boolean> GenerateDFAImmediately = new OptionKey((Object)false);
    private static final int BOOLEAN_MATCH = 512;
    public static final String BOOLEAN_MATCH_NAME = "BooleanMatch";
    @Option(category=OptionCategory.USER, stability=OptionStability.STABLE, help="Don't report capture groups, only return a boolean result.")
    public static final OptionKey<Boolean> BooleanMatch = new OptionKey((Object)false);
    private static final int MUST_ADVANCE = 1024;
    public static final String MUST_ADVANCE_NAME = "MustAdvance";
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.STABLE, help="Ignore matches that start exactly at the starting index.")
    public static final OptionKey<Boolean> MustAdvance = new OptionKey((Object)false);
    private static final int GENERATE_INPUT = 2048;
    public static final String GENERATE_INPUT_NAME = "GenerateInput";
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Try to generate strings the given regex would match. For internal testing only.")
    public static final OptionKey<Boolean> GenerateInput = new OptionKey((Object)false);
    private static final int FORCE_LINEAR_EXECUTION = 4096;
    @Option(category=OptionCategory.USER, stability=OptionStability.EXPERIMENTAL, help="Reject all regexes that cannot be executed in linear time.")
    public static final OptionKey<Boolean> ForceLinearExecution = new OptionKey((Object)false);
    public static final String FLAVOR_NAME = "Flavor";
    public static final String FLAVOR_PYTHON = "Python";
    public static final String FLAVOR_RUBY = "Ruby";
    public static final String FLAVOR_ORACLE_DB = "OracleDB";
    public static final String FLAVOR_ECMASCRIPT = "ECMAScript";
    public static final String FLAVOR_JAVA = "JavaUtilPattern";
    private static final RegexFlavor[] FLAVOR_CACHE = new RegexFlavor[FlavorOption.values().length];
    private static final String[] FLAVOR_OPTIONS = new String[]{"Python", "Ruby", "OracleDB", "ECMAScript", "JavaUtilPattern"};
    @Option(category=OptionCategory.USER, stability=OptionStability.STABLE, help="Regex flavor to use.", usageSyntax="ECMAScript|JavaUtilPattern|OracleDB|Python|Ruby")
    public static final OptionKey<FlavorOption> Flavor;
    public static final String ENCODING_NAME = "Encoding";
    @Option(category=OptionCategory.USER, stability=OptionStability.STABLE, help="Input string encoding.", usageSyntax="UTF-8|UTF-16|UTF-16-RAW|UTF-32|BYTES|LATIN-1")
    public static final OptionKey<Encodings.Encoding> Encoding;
    public static final String PYTHON_METHOD_NAME = "PythonMethod";
    public static final String MATCHING_MODE_NAME = "MatchingMode";
    public static final String MATCHING_MODE_SEARCH = "search";
    public static final String MATCHING_MODE_MATCH = "match";
    public static final String MATCHING_MODE_FULLMATCH = "fullmatch";
    private static final String[] MATCHING_MODE_OPTIONS;
    @Option(category=OptionCategory.USER, stability=OptionStability.STABLE, help="Regex matching mode. Supported modes are: 'search': Default. Search for a match anywhere in the input string. 'match': Anchor match at starting index. 'fullmatch': Anchor match at starting and end index.", usageSyntax="search|match|fullmatch")
    public static final OptionKey<MatchingMode> MatchingMode;
    public static final String PYTHON_LOCALE_NAME = "PythonLocale";
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, help="Locale to use for Python flavor's locale sensitive features.")
    public static final OptionKey<String> PythonLocale;
    public static final String JAVA_JDK_VERSION_NAME = "JavaJDKVersion";
    public static final String[] JAVA_JDK_VERSION_OPTIONS;
    public static final short JAVA_JDK_VERSION_MIN = 21;
    private static final short JAVA_JDK_VERSION_DEFAULT = 24;
    @Option(category=OptionCategory.USER, stability=OptionStability.STABLE, help="JDK compatibility version for Java flavor.", usageSyntax="21|22|23|24|25")
    public static final OptionKey<Integer> JavaJDKVersion;
    public static final String MAX_DFA_SIZE_NAME = "MaxDFASize";
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="DFA bailout threshold.")
    public static final OptionKey<Integer> MaxDFASize;
    public static final String MAX_BACK_TRACKER_SIZE_NAME = "MaxBackTrackerCompileSize";
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Backtracker JIT compilation bailout threshold.")
    public static final OptionKey<Integer> MaxBackTrackerJITSize;
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Single character class quantifier unroll limit.")
    public static final OptionKey<Integer> QuantifierUnrollLimitSingleCC;
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Group quantifier unroll limit.")
    public static final OptionKey<Integer> QuantifierUnrollLimitGroup;
    private static final String PARSE_SHORT_ERROR_MSG = "expected a short integer value";
    public static final RegexOptions DEFAULT;
    private final int options;
    private final short maxDFASize;
    private final short maxBackTrackerCompileSize;
    private final RegexFlavor flavor;
    private final Encodings.Encoding encoding;
    private final MatchingMode matchingMode;
    private final String pythonLocale;
    private final short javaJDKVersion;
    public final short quantifierUnrollLimitSingleCC;
    public final short quantifierUnrollLimitGroup;

    private static RegexFlavor getDefaultFlavor() {
        return FlavorOption.ECMAScript.get();
    }

    public static OptionDescriptors getDescriptors() {
        return new RegexOptionsOptionDescriptors();
    }

    private RegexOptions(int options, short maxDFASize, short maxBackTrackerCompileSize, RegexFlavor flavor, Encodings.Encoding encoding, MatchingMode matchingMode, String pythonLocale, short javaJDKVersion, short quantifierUnrollLimitSingleCC, short quantifierUnrollLimitGroup) {
        this.options = options;
        this.maxDFASize = maxDFASize;
        this.maxBackTrackerCompileSize = maxBackTrackerCompileSize;
        this.flavor = flavor;
        this.encoding = encoding;
        this.matchingMode = matchingMode;
        this.pythonLocale = pythonLocale;
        this.javaJDKVersion = javaJDKVersion;
        this.quantifierUnrollLimitSingleCC = quantifierUnrollLimitSingleCC;
        this.quantifierUnrollLimitGroup = quantifierUnrollLimitGroup;
    }

    public static Builder builder(TruffleLanguage.ParsingRequest parsingRequest) {
        return RegexOptions.builder(parsingRequest.getSource(), parsingRequest.getOptionValues());
    }

    public static Builder builder(Source source, OptionValues optionValues) {
        return new Builder(source, source.getCharacters().toString(), optionValues);
    }

    private boolean isBitSet(int bit) {
        return (this.options & bit) != 0;
    }

    public short getMaxDFASize() {
        return this.maxDFASize;
    }

    public short getMaxBackTrackerCompileSize() {
        return this.maxBackTrackerCompileSize;
    }

    public boolean isU180EWhitespace() {
        return this.isBitSet(1);
    }

    public boolean isRegressionTestMode() {
        return this.isBitSet(2);
    }

    public boolean isDumpAutomata() {
        return this.isBitSet(4);
    }

    public boolean isDumpAutomataWithSourceSections() {
        return this.isDumpAutomata() && (this.getFlavor().getName().equals(FLAVOR_ECMASCRIPT) || this.getFlavor().getName().equals(FLAVOR_ORACLE_DB));
    }

    public boolean isStepExecution() {
        return this.isBitSet(8);
    }

    public boolean isGenerateDFAImmediately() {
        return this.isBitSet(256);
    }

    public boolean isBooleanMatch() {
        return this.isBitSet(512);
    }

    public boolean isAlwaysEager() {
        return this.isBitSet(16);
    }

    public boolean isUTF16ExplodeAstralSymbols() {
        return this.isBitSet(32);
    }

    public boolean isValidate() {
        return this.isBitSet(64);
    }

    public boolean isIgnoreAtomicGroups() {
        return this.isBitSet(128);
    }

    public boolean isMustAdvance() {
        return this.isBitSet(1024);
    }

    public boolean isGenerateInput() {
        return this.isBitSet(2048);
    }

    public boolean isForceLinearExecution() {
        return this.isBitSet(4096);
    }

    public RegexFlavor getFlavor() {
        return this.flavor;
    }

    public Encodings.Encoding getEncoding() {
        return this.encoding;
    }

    public MatchingMode getMatchingMode() {
        return this.matchingMode;
    }

    public String getPythonLocale() {
        return this.pythonLocale;
    }

    public int getJavaJDKVersion() {
        return this.javaJDKVersion;
    }

    public RegexOptions withBooleanMatch() {
        return new RegexOptions(this.options | 0x200, this.maxDFASize, this.maxBackTrackerCompileSize, this.flavor, this.encoding, this.matchingMode, this.pythonLocale, this.javaJDKVersion, this.quantifierUnrollLimitSingleCC, this.quantifierUnrollLimitGroup);
    }

    public RegexOptions withoutBooleanMatch() {
        return new RegexOptions(this.options & 0xFFFFFDFF, this.maxDFASize, this.maxBackTrackerCompileSize, this.flavor, this.encoding, this.matchingMode, this.pythonLocale, this.javaJDKVersion, this.quantifierUnrollLimitSingleCC, this.quantifierUnrollLimitGroup);
    }

    public int hashCode() {
        int prime = 31;
        int hash = this.options;
        hash = 31 * hash + Objects.hashCode(this.maxDFASize);
        hash = 31 * hash + Objects.hashCode(this.maxBackTrackerCompileSize);
        hash = 31 * hash + Objects.hashCode(this.flavor);
        hash = 31 * hash + this.encoding.hashCode();
        hash = 31 * hash + Objects.hashCode((Object)this.matchingMode);
        hash = 31 * hash + Objects.hashCode(this.pythonLocale);
        hash = 31 * hash + Objects.hashCode(this.javaJDKVersion);
        hash = 31 * hash + Objects.hashCode(this.quantifierUnrollLimitSingleCC);
        hash = 31 * hash + Objects.hashCode(this.quantifierUnrollLimitGroup);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegexOptions)) {
            return false;
        }
        RegexOptions other = (RegexOptions)obj;
        return this.options == other.options && this.maxDFASize == other.maxDFASize && this.maxBackTrackerCompileSize == other.maxBackTrackerCompileSize && this.flavor == other.flavor && this.encoding == other.encoding && this.matchingMode == other.matchingMode && this.pythonLocale.equals(other.pythonLocale) && this.javaJDKVersion == other.javaJDKVersion && this.quantifierUnrollLimitSingleCC == other.quantifierUnrollLimitSingleCC && this.quantifierUnrollLimitGroup == other.quantifierUnrollLimitGroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.maxDFASize != 1300) {
            sb.append("MaxDFASize=").append(this.maxDFASize).append(',');
        }
        if (this.maxBackTrackerCompileSize != 200) {
            sb.append("MaxBackTrackerCompileSize=").append(this.maxBackTrackerCompileSize).append(',');
        }
        if (this.isU180EWhitespace()) {
            sb.append("U180EWhitespace=true,");
        }
        if (this.isRegressionTestMode()) {
            sb.append("RegressionTestMode=true,");
        }
        if (this.isDumpAutomata()) {
            sb.append("DumpAutomata=true,");
        }
        if (this.isStepExecution()) {
            sb.append("StepExecution=true,");
        }
        if (this.isAlwaysEager()) {
            sb.append("AlwaysEager=true,");
        }
        if (this.isUTF16ExplodeAstralSymbols()) {
            sb.append("UTF16ExplodeAstralSymbols=true,");
        }
        if (this.isValidate()) {
            sb.append("Validate=true,");
        }
        if (this.isIgnoreAtomicGroups()) {
            sb.append("IgnoreAtomicGroups=true,");
        }
        if (this.isGenerateDFAImmediately()) {
            sb.append("GenerateDFAImmediately=true,");
        }
        if (this.isBooleanMatch()) {
            sb.append("BooleanMatch=true,");
        }
        if (this.isMustAdvance()) {
            sb.append("MustAdvance=true,");
        }
        sb.append(FLAVOR_NAME).append('=').append(this.flavor.getName()).append(',');
        sb.append("Encoding=").append(this.encoding.getName()).append(",");
        if (this.matchingMode != null) {
            sb.append(MATCHING_MODE_NAME).append('=').append((Object)this.matchingMode).append(',');
        }
        if (this.pythonLocale != null) {
            sb.append("PythonLocale=").append(this.pythonLocale).append(",");
        }
        if (this.isGenerateInput()) {
            sb.append(GENERATE_INPUT_NAME).append("=true").append(",");
        }
        if (this.javaJDKVersion != 24) {
            sb.append(JAVA_JDK_VERSION_NAME).append("=").append(this.javaJDKVersion).append(",");
        }
        if (!sb.isEmpty()) {
            assert (sb.charAt(sb.length() - 1) == ',');
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    static {
        RegexOptions.FLAVOR_CACHE[FlavorOption.ECMAScript.ordinal()] = new JSFlavorProvider().get();
        RegexOptions.FLAVOR_CACHE[FlavorOption.Python.ordinal()] = new PythonFlavorProvider().get();
        RegexOptions.FLAVOR_CACHE[FlavorOption.Ruby.ordinal()] = new RubyFlavorProvider().get();
        RegexOptions.FLAVOR_CACHE[FlavorOption.OracleDB.ordinal()] = new OracleDBFlavorProvider().get();
        RegexOptions.FLAVOR_CACHE[FlavorOption.JavaUtilPattern.ordinal()] = new JavaFlavorProvider().get();
        Flavor = new OptionKey((Object)FlavorOption.ECMAScript);
        Encoding = new OptionKey((Object)Encodings.UTF_16_RAW, new OptionType(ENCODING_NAME, name -> {
            Encodings.Encoding enc = Encodings.getEncoding(name);
            if (enc == null) {
                throw new IllegalArgumentException(String.format("unknown encoding '%s'. Supported encodings are: UTF-8,UTF-16,UTF-16-RAW,UTF-32,BYTES,LATIN-1", name));
            }
            return enc;
        }));
        MATCHING_MODE_OPTIONS = new String[]{MATCHING_MODE_SEARCH, MATCHING_MODE_MATCH, MATCHING_MODE_FULLMATCH};
        MatchingMode = new OptionKey((Object)com.oracle.truffle.regex.tregex.parser.MatchingMode.search);
        PythonLocale = new OptionKey((Object)"");
        JAVA_JDK_VERSION_OPTIONS = new String[]{"21", "22", "23", "24", "25"};
        JavaJDKVersion = new OptionKey((Object)24);
        MaxDFASize = new OptionKey((Object)1300);
        MaxBackTrackerJITSize = new OptionKey((Object)200);
        QuantifierUnrollLimitSingleCC = new OptionKey((Object)20);
        QuantifierUnrollLimitGroup = new OptionKey((Object)6);
        DEFAULT = new RegexOptions(0, 1300, 200, RegexOptions.getDefaultFlavor(), Encodings.UTF_16_RAW, null, null, 24, 20, 6);
    }

    public static enum FlavorOption {
        ECMAScript,
        Python,
        Ruby,
        OracleDB,
        JavaUtilPattern;


        RegexFlavor get() {
            return FLAVOR_CACHE[this.ordinal()];
        }
    }

    public static final class Builder {
        private final Source source;
        private final String src;
        private final OptionValues optionValues;
        private int i;
        private int flags;
        private short maxDFASize = (short)1300;
        private short maxBackTrackerCompileSize = (short)200;
        private RegexFlavor flavor;
        private Encodings.Encoding encoding = Encodings.UTF_16_RAW;
        private MatchingMode matchingMode;
        private String pythonLocale;
        private short javaJDKVersion = (short)24;
        private short quantifierUnrollThresholdSingleCC;
        private short quantifierUnrollThresholdGroup;

        private Builder(Source source, String sourceString, OptionValues optionValues) {
            this.source = source;
            this.src = sourceString;
            this.optionValues = optionValues;
            this.flags = 0;
            this.flavor = RegexOptions.getDefaultFlavor();
            this.quantifierUnrollThresholdSingleCC = RegexOptions.DEFAULT.quantifierUnrollLimitSingleCC;
            this.quantifierUnrollThresholdGroup = RegexOptions.DEFAULT.quantifierUnrollLimitGroup;
        }

        @CompilerDirectives.TruffleBoundary
        public int parseOptions() throws RegexSyntaxException {
            if (this.src.startsWith("/")) {
                this.parseBooleanSrcOption(U180EWhitespace, 1);
                this.parseBooleanSrcOption(RegressionTestMode, 2);
                this.parseBooleanSrcOption(DumpAutomata, 4);
                this.parseBooleanSrcOption(DumpAutomataExecution, 8);
                this.parseBooleanSrcOption(AlwaysEager, 16);
                this.parseBooleanSrcOption(Validate, 64);
                this.parseBooleanSrcOption(IgnoreAtomicGroups, 128);
                this.parseBooleanSrcOption(GenerateDFAImmediately, 256);
                this.parseBooleanSrcOption(BooleanMatch, 512);
                this.parseBooleanSrcOption(MustAdvance, 1024);
                this.parseBooleanSrcOption(GenerateInput, 2048);
                this.parseBooleanSrcOption(ForceLinearExecution, 4096);
                this.flavor = ((FlavorOption)((Object)this.optionValues.get(Flavor))).get();
                this.encoding = (Encodings.Encoding)this.optionValues.get(Encoding);
                this.matchingMode = (MatchingMode)((Object)this.optionValues.get(MatchingMode));
                this.pythonLocale = (String)this.optionValues.get(PythonLocale);
                this.javaJDKVersion = this.parseShortSrcOption(RegexOptions.JAVA_JDK_VERSION_NAME, JavaJDKVersion, 21);
                this.maxDFASize = this.parseShortSrcOption(RegexOptions.MAX_DFA_SIZE_NAME, MaxDFASize, 0);
                this.maxBackTrackerCompileSize = this.parseShortSrcOption("MaxBackTrackerJITSize", MaxBackTrackerJITSize, 0);
                this.quantifierUnrollThresholdSingleCC = this.parseShortSrcOption("QuantifierUnrollLimitSingleCC", QuantifierUnrollLimitSingleCC, 1);
                this.quantifierUnrollThresholdGroup = this.parseShortSrcOption("QuantifierUnrollLimitGroup", QuantifierUnrollLimitGroup, 1);
                return 0;
            }
            this.i = 0;
            block36: while (this.i < this.src.length()) {
                switch (this.src.charAt(this.i)) {
                    case 'A': {
                        this.parseBooleanOption(RegexOptions.ALWAYS_EAGER_NAME, 16);
                        continue block36;
                    }
                    case 'B': {
                        this.parseBooleanOption(RegexOptions.BOOLEAN_MATCH_NAME, 512);
                        continue block36;
                    }
                    case 'D': {
                        this.parseBooleanOption(RegexOptions.DUMP_AUTOMATA_NAME, 4);
                        continue block36;
                    }
                    case 'E': {
                        this.encoding = this.parseEncoding();
                        continue block36;
                    }
                    case 'F': {
                        this.flavor = this.parseFlavor();
                        continue block36;
                    }
                    case 'G': {
                        switch (this.lookAheadInKey("Generate".length())) {
                            case 'D': {
                                this.parseBooleanOption(RegexOptions.GENERATE_DFA_IMMEDIATELY_NAME, 256);
                                continue block36;
                            }
                            case 'I': {
                                this.parseBooleanOption(RegexOptions.GENERATE_INPUT_NAME, 2048);
                                continue block36;
                            }
                        }
                        throw this.optionsSyntaxErrorUnexpectedKey();
                    }
                    case 'I': {
                        this.parseBooleanOption(RegexOptions.IGNORE_ATOMIC_GROUPS_NAME, 128);
                        continue block36;
                    }
                    case 'J': {
                        short version = this.parseShortOption(RegexOptions.JAVA_JDK_VERSION_NAME);
                        if (version < 21) {
                            throw this.optionsSyntaxErrorUnexpectedValue(JAVA_JDK_VERSION_OPTIONS);
                        }
                        this.javaJDKVersion = (byte)version;
                        continue block36;
                    }
                    case 'M': {
                        switch (this.lookAheadInKey(3)) {
                            case 'B': {
                                this.maxBackTrackerCompileSize = this.parseShortOption(RegexOptions.MAX_BACK_TRACKER_SIZE_NAME);
                                continue block36;
                            }
                            case 'D': {
                                this.maxDFASize = this.parseShortOption(RegexOptions.MAX_DFA_SIZE_NAME);
                                continue block36;
                            }
                            case 'c': {
                                this.matchingMode = this.parseMatchingMode(RegexOptions.MATCHING_MODE_NAME);
                                continue block36;
                            }
                            case 't': {
                                this.parseBooleanOption(RegexOptions.MUST_ADVANCE_NAME, 1024);
                                continue block36;
                            }
                        }
                        throw this.optionsSyntaxErrorUnexpectedKey();
                    }
                    case 'P': {
                        switch (this.lookAheadInKey(RegexOptions.FLAVOR_PYTHON.length())) {
                            case 'M': {
                                this.matchingMode = this.parseMatchingMode(RegexOptions.PYTHON_METHOD_NAME);
                                continue block36;
                            }
                            case 'L': {
                                this.pythonLocale = this.parseStringOption(RegexOptions.PYTHON_LOCALE_NAME, "expected a python locale name");
                                continue block36;
                            }
                        }
                        throw this.optionsSyntaxErrorUnexpectedKey();
                    }
                    case 'R': {
                        this.parseBooleanOption(RegexOptions.REGRESSION_TEST_MODE_NAME, 2);
                        continue block36;
                    }
                    case 'S': {
                        this.parseBooleanOption(RegexOptions.STEP_EXECUTION_NAME, 8);
                        continue block36;
                    }
                    case 'U': {
                        switch (this.lookAheadInKey(1)) {
                            case '1': {
                                this.parseBooleanOption(RegexOptions.U180E_WHITESPACE_NAME, 1);
                                continue block36;
                            }
                            case 'T': {
                                this.parseBooleanOption(RegexOptions.UTF_16_EXPLODE_ASTRAL_SYMBOLS_NAME, 32);
                                continue block36;
                            }
                        }
                        throw this.optionsSyntaxErrorUnexpectedKey();
                    }
                    case 'V': {
                        this.parseBooleanOption(RegexOptions.VALIDATE_NAME, 64);
                        continue block36;
                    }
                    case ',': {
                        ++this.i;
                        continue block36;
                    }
                    case '/': {
                        return this.i;
                    }
                }
                throw this.optionsSyntaxErrorUnexpectedKey();
            }
            return this.i;
        }

        private void parseBooleanSrcOption(OptionKey<Boolean> key, int flag) {
            if (((Boolean)this.optionValues.get(key)).booleanValue()) {
                this.flags |= flag;
            }
        }

        private short parseShortSrcOption(String optionName, OptionKey<Integer> key, int min) {
            int value = (Integer)this.optionValues.get(key);
            if (value < min) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg("value of " + optionName + " must be greater or equal to " + min);
            }
            if (value > Short.MAX_VALUE) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg("value of " + optionName + " must be less or equal to 32767");
            }
            return (short)value;
        }

        private char lookAheadInKey(int offset) {
            if (Integer.compareUnsigned(this.i + offset, this.src.length()) >= 0) {
                throw this.optionsSyntaxErrorUnexpectedKey();
            }
            return this.src.charAt(this.i + offset);
        }

        private void expectOptionName(String key) {
            if (!this.src.regionMatches(this.i, key, 0, key.length()) || this.src.charAt(this.i + key.length()) != '=') {
                throw this.optionsSyntaxErrorUnexpectedKey();
            }
            this.i += key.length() + 1;
        }

        private <T> T expectValue(T returnValue, String value, String ... expected) {
            if (!this.src.regionMatches(this.i, value, 0, value.length())) {
                throw this.optionsSyntaxErrorUnexpectedValue(expected);
            }
            this.i += value.length();
            return returnValue;
        }

        private void parseBooleanOption(String key, int flag) throws RegexSyntaxException {
            this.expectOptionName(key);
            if (this.src.regionMatches(this.i, "true", 0, "true".length())) {
                this.flags |= flag;
                this.i += "true".length();
            } else if (this.src.regionMatches(this.i, "false", 0, "false".length())) {
                this.i += "false".length();
            } else {
                throw this.optionsSyntaxErrorUnexpectedValue("true", "false");
            }
        }

        private short parseShortOption(String key) throws RegexSyntaxException {
            this.expectOptionName(key);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg(RegexOptions.PARSE_SHORT_ERROR_MSG);
            }
            int endPos = this.findValueEndPos(RegexOptions.PARSE_SHORT_ERROR_MSG);
            try {
                int value = Integer.parseUnsignedInt(this.src, this.i, endPos, 10);
                if (value < 0 || value > Short.MAX_VALUE) {
                    throw this.optionsSyntaxErrorUnexpectedValueMsg(RegexOptions.PARSE_SHORT_ERROR_MSG);
                }
                this.i = endPos;
                return (short)value;
            }
            catch (NumberFormatException e) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg(RegexOptions.PARSE_SHORT_ERROR_MSG);
            }
        }

        private String parseStringOption(String key, String errorMsg) throws RegexSyntaxException {
            this.expectOptionName(key);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg(errorMsg);
            }
            int endPos = this.findValueEndPos(errorMsg);
            String value = this.src.substring(this.i, endPos);
            this.i = endPos;
            return value;
        }

        private int findValueEndPos(String errorMsg) {
            int endPos = ArrayUtils.indexOf((String)this.src, (int)this.i, (int)this.src.length(), (char[])new char[]{',', '/'});
            if (endPos < 0) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg(errorMsg);
            }
            return endPos;
        }

        private RegexFlavor parseFlavor() throws RegexSyntaxException {
            this.expectOptionName(RegexOptions.FLAVOR_NAME);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValue(FLAVOR_OPTIONS);
            }
            switch (this.src.charAt(this.i)) {
                case 'E': {
                    return this.expectValue(FlavorOption.ECMAScript, RegexOptions.FLAVOR_ECMASCRIPT, FLAVOR_OPTIONS).get();
                }
                case 'J': {
                    return this.expectValue(FlavorOption.JavaUtilPattern, RegexOptions.FLAVOR_JAVA, FLAVOR_OPTIONS).get();
                }
                case 'R': {
                    return this.expectValue(FlavorOption.Ruby, RegexOptions.FLAVOR_RUBY, FLAVOR_OPTIONS).get();
                }
                case 'O': {
                    return this.expectValue(FlavorOption.OracleDB, RegexOptions.FLAVOR_ORACLE_DB, FLAVOR_OPTIONS).get();
                }
                case 'P': {
                    return this.expectValue(FlavorOption.Python, RegexOptions.FLAVOR_PYTHON, FLAVOR_OPTIONS).get();
                }
            }
            throw this.optionsSyntaxErrorUnexpectedValue(FLAVOR_OPTIONS);
        }

        private Encodings.Encoding parseEncoding() throws RegexSyntaxException {
            this.expectOptionName(RegexOptions.ENCODING_NAME);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValue(Encodings.ALL_NAMES);
            }
            switch (this.src.charAt(this.i)) {
                case 'A': {
                    return this.expectEncodingValue(Encodings.ASCII);
                }
                case 'B': {
                    return this.expectValue(Encodings.BYTES, "BYTES", Encodings.ALL_NAMES);
                }
                case 'L': {
                    return this.expectEncodingValue(Encodings.LATIN_1);
                }
                case 'U': {
                    switch (this.lookAheadInKey(4)) {
                        case '8': {
                            return this.expectEncodingValue(Encodings.UTF_8);
                        }
                        case '1': {
                            return this.expectEncodingValue(Encodings.UTF_16);
                        }
                        case '3': {
                            return this.expectEncodingValue(Encodings.UTF_32);
                        }
                    }
                    throw this.optionsSyntaxErrorUnexpectedValue(Encodings.ALL_NAMES);
                }
            }
            throw this.optionsSyntaxErrorUnexpectedValue(Encodings.ALL_NAMES);
        }

        private Encodings.Encoding expectEncodingValue(Encodings.Encoding enc) {
            return this.expectValue(enc, enc.getName(), Encodings.ALL_NAMES);
        }

        private MatchingMode parseMatchingMode(String optionName) throws RegexSyntaxException {
            this.expectOptionName(optionName);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValue(MATCHING_MODE_OPTIONS);
            }
            switch (this.src.charAt(this.i)) {
                case 's': {
                    return this.expectValue(com.oracle.truffle.regex.tregex.parser.MatchingMode.search, RegexOptions.MATCHING_MODE_SEARCH, MATCHING_MODE_OPTIONS);
                }
                case 'm': {
                    return this.expectValue(com.oracle.truffle.regex.tregex.parser.MatchingMode.match, RegexOptions.MATCHING_MODE_MATCH, MATCHING_MODE_OPTIONS);
                }
                case 'f': {
                    return this.expectValue(com.oracle.truffle.regex.tregex.parser.MatchingMode.fullmatch, RegexOptions.MATCHING_MODE_FULLMATCH, MATCHING_MODE_OPTIONS);
                }
            }
            throw this.optionsSyntaxErrorUnexpectedValue(MATCHING_MODE_OPTIONS);
        }

        @CompilerDirectives.TruffleBoundary
        private RegexSyntaxException optionsSyntaxErrorUnexpectedKey() {
            int eqlPos = this.src.indexOf(61, this.i);
            return this.optionsSyntaxError(String.format("unexpected option '%s'", this.src.substring(this.i, eqlPos < 0 ? this.src.length() : eqlPos)));
        }

        @CompilerDirectives.TruffleBoundary
        private RegexSyntaxException optionsSyntaxErrorUnexpectedValue(String ... expected) {
            return this.optionsSyntaxErrorUnexpectedValueMsg(String.format("expected one of %s", Arrays.toString(expected)));
        }

        @CompilerDirectives.TruffleBoundary
        private RegexSyntaxException optionsSyntaxErrorUnexpectedValueMsg(String msg) {
            int commaPos = this.src.indexOf(44, this.i);
            String value = this.src.substring(this.i, commaPos < 0 ? this.src.length() : commaPos);
            return this.optionsSyntaxError(String.format("unexpected value '%s', %s", value, msg));
        }

        @CompilerDirectives.TruffleBoundary
        private RegexSyntaxException optionsSyntaxError(String msg) {
            return RegexSyntaxException.createOptions(this.source, String.format("Invalid options syntax in '%s': %s", this.src, msg), this.i);
        }

        private boolean isBitSet(int bit) {
            return (this.flags & bit) != 0;
        }

        public boolean isUtf16ExplodeAstralSymbols() {
            return this.isBitSet(32);
        }

        public Builder flavor(RegexFlavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public RegexFlavor getFlavor() {
            return this.flavor;
        }

        public Builder encoding(Encodings.Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public Encodings.Encoding getEncoding() {
            return this.encoding;
        }

        public RegexOptions build() {
            return new RegexOptions(this.flags, this.maxDFASize, this.maxBackTrackerCompileSize, this.flavor, this.encoding, this.matchingMode, this.pythonLocale, this.javaJDKVersion, this.quantifierUnrollThresholdSingleCC, this.quantifierUnrollThresholdGroup);
        }
    }
}

