/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.buffer;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;

@GenerateLibrary
public abstract class PythonBufferAccessLibrary
extends Library {
    static final LibraryFactory<PythonBufferAccessLibrary> FACTORY = LibraryFactory.resolve(PythonBufferAccessLibrary.class);

    @GenerateLibrary.Abstract
    public boolean isBuffer(Object receiver) {
        return false;
    }

    public static void assertIsBuffer(Object receiver) {
        assert (PythonBufferAccessLibrary.getUncached().isBuffer(receiver));
    }

    public void release(Object receiver) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(Object receiver, VirtualFrame frame, IndirectCallData indirectCallData) {
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, (Node)this, indirectCallData);
        try {
            this.release(receiver);
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, (Node)this, indirectCallData, savedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(Object receiver, VirtualFrame frame, PythonContext context, PythonLanguage language, IndirectCallData indirectCallData) {
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
        try {
            this.release(receiver);
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, language, context, savedState);
        }
    }

    @GenerateLibrary.Abstract
    public int getBufferLength(Object receiver) {
        throw CompilerDirectives.shouldNotReachHere((String)"getBufferLength");
    }

    @GenerateLibrary.Abstract(ifExported={"writeByte"})
    public boolean isReadonly(Object receiver) {
        return true;
    }

    public boolean hasInternalByteArray(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasInternalByteArray"})
    public byte[] getInternalByteArray(Object receiver) {
        throw CompilerDirectives.shouldNotReachHere((String)"getInternalByteArray");
    }

    public void readIntoByteArray(Object receiver, int srcOffset, byte[] dest, int destOffset, int length) {
        if (this.hasInternalByteArray(receiver)) {
            PythonUtils.arraycopy(this.getInternalByteArray(receiver), srcOffset, dest, destOffset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                dest[destOffset + i] = this.readByte(receiver, srcOffset + i);
            }
        }
    }

    public void writeFromByteArray(Object receiver, int destOffset, byte[] src, int srcOffset, int length) {
        if (this.hasInternalByteArray(receiver)) {
            PythonUtils.arraycopy(src, srcOffset, this.getInternalByteArray(receiver), destOffset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                this.writeByte(receiver, destOffset + i, src[srcOffset + i]);
            }
        }
    }

    public void readIntoBuffer(Object receiver, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
        if (this.hasInternalByteArray(receiver) && otherLib.hasInternalByteArray(dest)) {
            PythonUtils.arraycopy(this.getInternalByteArray(receiver), srcOffset, otherLib.getInternalByteArray(dest), destOffset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                otherLib.writeByte(dest, destOffset + i, this.readByte(receiver, srcOffset + i));
            }
        }
    }

    public final byte[] getCopiedByteArray(Object receiver) {
        int len = this.getBufferLength(receiver);
        byte[] bytes = new byte[len];
        this.readIntoByteArray(receiver, 0, bytes, 0, len);
        return bytes;
    }

    public final byte[] getCopyOfRange(Object receiver, int from, int to) {
        int len = to - from;
        assert (len >= 0);
        byte[] newBuf = new byte[len];
        this.readIntoByteArray(receiver, from, newBuf, 0, len);
        return newBuf;
    }

    public final byte[] getInternalOrCopiedByteArray(Object receiver) {
        if (this.hasInternalByteArray(receiver)) {
            return this.getInternalByteArray(receiver);
        }
        return this.getCopiedByteArray(receiver);
    }

    public final byte[] getInternalOrCopiedExactByteArray(Object receiver) {
        byte[] r;
        if (this.hasInternalByteArray(receiver) && (r = this.getInternalByteArray(receiver)).length == this.getBufferLength(receiver)) {
            return r;
        }
        return this.getCopiedByteArray(receiver);
    }

    @GenerateLibrary.Abstract
    public byte readByte(Object receiver, int byteOffset) {
        throw CompilerDirectives.shouldNotReachHere((String)"readByte");
    }

    public short readShort(Object receiver, int byteOffset) {
        return this.readShortByteOrder(receiver, byteOffset, ByteOrder.nativeOrder());
    }

    public short readShortByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
        byte b1 = this.readByte(receiver, byteOffset);
        byte b2 = this.readByte(receiver, byteOffset + 1);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
        }
        return (short)((b1 & 0xFF) << 8 | b2 & 0xFF);
    }

    public int readInt(Object receiver, int byteOffset) {
        return this.readIntByteOrder(receiver, byteOffset, ByteOrder.nativeOrder());
    }

    public int readIntByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
        byte b1 = this.readByte(receiver, byteOffset);
        byte b2 = this.readByte(receiver, byteOffset + 1);
        byte b3 = this.readByte(receiver, byteOffset + 2);
        byte b4 = this.readByte(receiver, byteOffset + 3);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
        }
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public long readLong(Object receiver, int byteOffset) {
        return this.readLongByteOrder(receiver, byteOffset, ByteOrder.nativeOrder());
    }

    public long readLongByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
        byte b1 = this.readByte(receiver, byteOffset);
        byte b2 = this.readByte(receiver, byteOffset + 1);
        byte b3 = this.readByte(receiver, byteOffset + 2);
        byte b4 = this.readByte(receiver, byteOffset + 3);
        byte b5 = this.readByte(receiver, byteOffset + 4);
        byte b6 = this.readByte(receiver, byteOffset + 5);
        byte b7 = this.readByte(receiver, byteOffset + 6);
        byte b8 = this.readByte(receiver, byteOffset + 7);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return ((long)b8 & 0xFFL) << 56 | ((long)b7 & 0xFFL) << 48 | ((long)b6 & 0xFFL) << 40 | ((long)b5 & 0xFFL) << 32 | ((long)b4 & 0xFFL) << 24 | ((long)b3 & 0xFFL) << 16 | ((long)b2 & 0xFFL) << 8 | (long)b1 & 0xFFL;
        }
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    public float readFloat16(Object receiver, int byteOffset) {
        return this.readFloat16ByteOrder(receiver, byteOffset, ByteOrder.nativeOrder());
    }

    public float readFloat16ByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
        return Float.float16ToFloat(this.readShortByteOrder(receiver, byteOffset, byteOrder));
    }

    public float readFloat(Object receiver, int byteOffset) {
        return this.readFloatByteOrder(receiver, byteOffset, ByteOrder.nativeOrder());
    }

    public float readFloatByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
        return Float.intBitsToFloat(this.readIntByteOrder(receiver, byteOffset, byteOrder));
    }

    public double readDouble(Object receiver, int byteOffset) {
        return this.readDoubleByteOrder(receiver, byteOffset, ByteOrder.nativeOrder());
    }

    public double readDoubleByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
        return Double.longBitsToDouble(this.readLongByteOrder(receiver, byteOffset, byteOrder));
    }

    @GenerateLibrary.Abstract(ifExported={"isReadonly"})
    public void writeByte(Object receiver, int byteOffset, byte value) {
        throw CompilerDirectives.shouldNotReachHere((String)"writeByte not implemented");
    }

    public void writeShort(Object receiver, int byteOffset, short value) {
        this.writeShortByteOrder(receiver, byteOffset, value, ByteOrder.nativeOrder());
    }

    public void writeShortByteOrder(Object receiver, int byteOffset, short value, ByteOrder byteOrder) {
        byte b1 = (byte)(value >> 8);
        byte b2 = (byte)value;
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.writeByte(receiver, byteOffset, b2);
            this.writeByte(receiver, byteOffset + 1, b1);
        } else {
            this.writeByte(receiver, byteOffset, b1);
            this.writeByte(receiver, byteOffset + 1, b2);
        }
    }

    public void writeInt(Object receiver, int byteOffset, int value) {
        this.writeIntByteOrder(receiver, byteOffset, value, ByteOrder.nativeOrder());
    }

    public void writeIntByteOrder(Object receiver, int byteOffset, int value, ByteOrder byteOrder) {
        byte b1 = (byte)(value >> 24);
        byte b2 = (byte)(value >> 16);
        byte b3 = (byte)(value >> 8);
        byte b4 = (byte)value;
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.writeByte(receiver, byteOffset, b4);
            this.writeByte(receiver, byteOffset + 1, b3);
            this.writeByte(receiver, byteOffset + 2, b2);
            this.writeByte(receiver, byteOffset + 3, b1);
        } else {
            this.writeByte(receiver, byteOffset, b1);
            this.writeByte(receiver, byteOffset + 1, b2);
            this.writeByte(receiver, byteOffset + 2, b3);
            this.writeByte(receiver, byteOffset + 3, b4);
        }
    }

    public void writeLong(Object receiver, int byteOffset, long value) {
        this.writeLongByteOrder(receiver, byteOffset, value, ByteOrder.nativeOrder());
    }

    public void writeLongByteOrder(Object receiver, int byteOffset, long value, ByteOrder byteOrder) {
        byte b1 = (byte)(value >> 56);
        byte b2 = (byte)(value >> 48);
        byte b3 = (byte)(value >> 40);
        byte b4 = (byte)(value >> 32);
        byte b5 = (byte)(value >> 24);
        byte b6 = (byte)(value >> 16);
        byte b7 = (byte)(value >> 8);
        byte b8 = (byte)value;
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.writeByte(receiver, byteOffset, b8);
            this.writeByte(receiver, byteOffset + 1, b7);
            this.writeByte(receiver, byteOffset + 2, b6);
            this.writeByte(receiver, byteOffset + 3, b5);
            this.writeByte(receiver, byteOffset + 4, b4);
            this.writeByte(receiver, byteOffset + 5, b3);
            this.writeByte(receiver, byteOffset + 6, b2);
            this.writeByte(receiver, byteOffset + 7, b1);
        } else {
            this.writeByte(receiver, byteOffset, b1);
            this.writeByte(receiver, byteOffset + 1, b2);
            this.writeByte(receiver, byteOffset + 2, b3);
            this.writeByte(receiver, byteOffset + 3, b4);
            this.writeByte(receiver, byteOffset + 4, b5);
            this.writeByte(receiver, byteOffset + 5, b6);
            this.writeByte(receiver, byteOffset + 6, b7);
            this.writeByte(receiver, byteOffset + 7, b8);
        }
    }

    public void writeFloat16(Object receiver, int byteOffset, float value) {
        this.writeFloat16ByteOrder(receiver, byteOffset, value, ByteOrder.nativeOrder());
    }

    public void writeFloat16ByteOrder(Object receiver, int byteOffset, float value, ByteOrder byteOrder) {
        this.writeShortByteOrder(receiver, byteOffset, Float.floatToFloat16(value), byteOrder);
    }

    public void writeFloat(Object receiver, int byteOffset, float value) {
        this.writeFloatByteOrder(receiver, byteOffset, value, ByteOrder.nativeOrder());
    }

    public void writeFloatByteOrder(Object receiver, int byteOffset, float value, ByteOrder byteOrder) {
        this.writeIntByteOrder(receiver, byteOffset, Float.floatToIntBits(value), byteOrder);
    }

    public void writeDouble(Object receiver, int byteOffset, double value) {
        this.writeDoubleByteOrder(receiver, byteOffset, value, ByteOrder.nativeOrder());
    }

    public void writeDoubleByteOrder(Object receiver, int byteOffset, double value, ByteOrder byteOrder) {
        this.writeLongByteOrder(receiver, byteOffset, Double.doubleToLongBits(value), byteOrder);
    }

    public Object getOwner(Object receiver) {
        return receiver;
    }

    @GenerateLibrary.Abstract(ifExported={"getFormatString"})
    public int getItemSize(Object receiver) {
        return 1;
    }

    @GenerateLibrary.Abstract(ifExported={"getItemSize"})
    public TruffleString getFormatString(Object receiver) {
        return BufferFormat.T_UINT_8_TYPE_CODE;
    }

    @GenerateLibrary.Abstract(ifExported={"getNativePointer"})
    public boolean isNative(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNative"})
    public Object getNativePointer(Object receiver) {
        return null;
    }

    public static LibraryFactory<PythonBufferAccessLibrary> getFactory() {
        return FACTORY;
    }

    public static PythonBufferAccessLibrary getUncached() {
        return (PythonBufferAccessLibrary)FACTORY.getUncached();
    }
}

