/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.deserialization;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializerKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/FirJvmConstDeserializer;", "Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "binaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "protocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "<init>", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "loadConstant", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "isUnsigned", "", "fir-jvm"})
public final class FirJvmConstDeserializer
extends FirConstDeserializer {
    @NotNull
    private final KotlinJvmBinaryClass binaryClass;

    public FirJvmConstDeserializer(@NotNull KotlinJvmBinaryClass binaryClass, @NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkNotNullParameter(binaryClass, "binaryClass");
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        super(protocol);
        this.binaryClass = binaryClass;
    }

    @Override
    @Nullable
    public FirExpression loadConstant(@NotNull ProtoBuf.Property propertyProto, @NotNull CallableId callableId, @NotNull NameResolver nameResolver, boolean isUnsigned) {
        Intrinsics.checkNotNullParameter(propertyProto, "propertyProto");
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        if (!Flags.HAS_CONSTANT.get(propertyProto.getFlags()).booleanValue()) {
            return null;
        }
        FirLiteralExpression firLiteralExpression = this.getConstantCache().get(callableId);
        if (firLiteralExpression != null) {
            FirLiteralExpression it = firLiteralExpression;
            boolean bl = false;
            if (it.getKind().isUnsigned() != isUnsigned) {
                ConstantValueKind newKind = isUnsigned ? it.getKind().toUnsigned() : it.getKind().toSigned();
                it.replaceKind(newKind);
                it.replaceConeTypeOrNull(FirConstExpressionBuilderKt.toConeType(newKind));
            }
            return it;
        }
        this.binaryClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(nameResolver, isUnsigned, this, callableId){
            final /* synthetic */ NameResolver $nameResolver;
            final /* synthetic */ boolean $isUnsigned;
            final /* synthetic */ FirJvmConstDeserializer this$0;
            final /* synthetic */ CallableId $callableId;
            {
                this.$nameResolver = $nameResolver;
                this.$isUnsigned = $isUnsigned;
                this.this$0 = $receiver;
                this.$callableId = $callableId;
            }

            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(Name name2, String desc) {
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(desc, "desc");
                return null;
            }

            public KotlinJvmBinaryClass.AnnotationVisitor visitField(Name name2, String desc, Object initializer) {
                block1: {
                    FirLiteralExpression constant;
                    Intrinsics.checkNotNullParameter(name2, "name");
                    Intrinsics.checkNotNullParameter(desc, "desc");
                    if (initializer == null) break block1;
                    FirLiteralExpression firLiteralExpression = constant = FirConstDeserializerKt.buildFirConstant(null, initializer, desc, this.$nameResolver, this.$isUnsigned);
                    if (firLiteralExpression != null) {
                        FirLiteralExpression firLiteralExpression2 = firLiteralExpression;
                        FirJvmConstDeserializer firJvmConstDeserializer = this.this$0;
                        CallableId callableId = this.$callableId;
                        FirLiteralExpression it = firLiteralExpression2;
                        boolean bl = false;
                        FirJvmConstDeserializer.access$getConstantCache(firJvmConstDeserializer).put(FirConstDeserializerKt.replaceName(callableId, name2), it);
                    }
                }
                return null;
            }
        }, null);
        return this.getConstantCache().get(callableId);
    }

    public static final /* synthetic */ Map access$getConstantCache(FirJvmConstDeserializer $this) {
        return $this.getConstantCache();
    }
}

