/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.Optional;

public class SharePartitionOffsetInfo {
    private final long startOffset;
    private final Optional<Integer> leaderEpoch;
    private final Optional<Long> lag;

    public SharePartitionOffsetInfo(long startOffset, Optional<Integer> leaderEpoch, Optional<Long> lag) {
        this.startOffset = startOffset;
        this.leaderEpoch = leaderEpoch;
        this.lag = lag;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public Optional<Integer> leaderEpoch() {
        return this.leaderEpoch;
    }

    public Optional<Long> lag() {
        return this.lag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharePartitionOffsetInfo that = (SharePartitionOffsetInfo)o;
        return this.startOffset == that.startOffset && Objects.equals(this.leaderEpoch, that.leaderEpoch) && Objects.equals(this.lag, that.lag);
    }

    public int hashCode() {
        return Objects.hash(this.startOffset, this.leaderEpoch, this.lag);
    }

    public String toString() {
        return "SharePartitionOffsetInfo{startOffset=" + this.startOffset + ", leaderEpoch=" + String.valueOf(this.leaderEpoch.orElse(null)) + ", lag=" + String.valueOf(this.lag.orElse(null)) + "}";
    }
}

