/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.io.IOException;
import java.io.OutputStream;
import json.ext.RuntimeInfo;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

final class Utils {
    public static final String M_GENERATOR_ERROR = "GeneratorError";
    public static final String M_NESTING_ERROR = "NestingError";
    public static final String M_PARSER_ERROR = "ParserError";

    private Utils() {
        throw new RuntimeException();
    }

    static RubyArray ensureArray(IRubyObject iRubyObject) throws RaiseException {
        if (iRubyObject instanceof RubyArray) {
            return (RubyArray)iRubyObject;
        }
        Ruby ruby = iRubyObject.getRuntime();
        throw ruby.newTypeError(iRubyObject, ruby.getArray());
    }

    static RubyString ensureString(IRubyObject iRubyObject) throws RaiseException {
        if (iRubyObject instanceof RubyString) {
            return (RubyString)iRubyObject;
        }
        Ruby ruby = iRubyObject.getRuntime();
        throw ruby.newTypeError(iRubyObject, ruby.getString());
    }

    static RaiseException newException(ThreadContext threadContext, String string, String string2) {
        return Utils.newException(threadContext, string, threadContext.runtime.newString(string2));
    }

    static RaiseException newException(ThreadContext threadContext, String string, RubyString rubyString) {
        RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(threadContext.runtime);
        RubyClass rubyClass = ((RubyModule)runtimeInfo.jsonModule.get()).getClass(string);
        RubyException rubyException = (RubyException)rubyClass.newInstance(threadContext, (IRubyObject)rubyString, Block.NULL_BLOCK);
        return rubyException.toThrowable();
    }

    static RubyException buildGeneratorError(ThreadContext threadContext, IRubyObject iRubyObject, RubyString rubyString) {
        RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(threadContext.runtime);
        RubyClass rubyClass = ((RubyModule)runtimeInfo.jsonModule.get()).getClass(M_GENERATOR_ERROR);
        RubyException rubyException = (RubyException)rubyClass.newInstance(threadContext, (IRubyObject)rubyString, Block.NULL_BLOCK);
        rubyException.setInstanceVariable("@invalid_object", iRubyObject);
        return rubyException;
    }

    static RubyException buildGeneratorError(ThreadContext threadContext, IRubyObject iRubyObject, String string) {
        return Utils.buildGeneratorError(threadContext, iRubyObject, threadContext.runtime.newString(string));
    }

    static byte[] repeat(ByteList byteList, int n) {
        return Utils.repeat(byteList.unsafeBytes(), byteList.begin(), byteList.length(), n);
    }

    static byte[] repeat(byte[] byArray, int n, int n2, int n3) {
        if (n2 == 0) {
            return ByteList.NULL_ARRAY;
        }
        if (n3 == 1 && n == 0 && n2 == byArray.length) {
            return byArray;
        }
        int n4 = n2 * n3;
        byte[] byArray2 = new byte[n4];
        for (int i = 0; i < n4; i += n2) {
            System.arraycopy(byArray, n, byArray2, i, n2);
        }
        return byArray2;
    }

    static void repeatWrite(OutputStream outputStream, ByteList byteList, int n) throws IOException {
        byte[] byArray = byteList.unsafeBytes();
        int n2 = byteList.begin();
        int n3 = byteList.length();
        for (int i = 0; i < n; ++i) {
            outputStream.write(byArray, n2, n3);
        }
    }
}

