/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.inject.Inject;
import net.rubygrapefruit.platform.SystemInfo;
import org.gradle.api.GradleException;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.platform.Architecture;
import org.gradle.platform.BuildPlatform;
import org.gradle.platform.BuildPlatformFactory;
import org.gradle.platform.OperatingSystem;

@ServiceScope(value={Scope.Global.class})
public class CurrentBuildPlatform {
    private final Supplier<Architecture> architecture;
    private final OperatingSystem operatingSystem;

    @Inject
    public CurrentBuildPlatform(final SystemInfo systemInfo, org.gradle.internal.os.OperatingSystem operatingSystem) {
        this.architecture = Suppliers.memoize((Supplier)new Supplier<Architecture>(){

            public Architecture get() {
                return CurrentBuildPlatform.getArchitecture(systemInfo);
            }
        });
        this.operatingSystem = CurrentBuildPlatform.getOperatingSystem(operatingSystem);
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Architecture getArchitecture() {
        return (Architecture)((Object)this.architecture.get());
    }

    private static Architecture getArchitecture(SystemInfo systemInfo) {
        SystemInfo.Architecture architecture = systemInfo.getArchitecture();
        switch (architecture) {
            case i386: {
                return Architecture.X86;
            }
            case amd64: {
                return Architecture.X86_64;
            }
            case aarch64: {
                return Architecture.AARCH64;
            }
        }
        throw new GradleException("Unhandled system architecture: " + architecture);
    }

    public static OperatingSystem getOperatingSystem(org.gradle.internal.os.OperatingSystem operatingSystem) {
        if (org.gradle.internal.os.OperatingSystem.LINUX == operatingSystem) {
            return OperatingSystem.LINUX;
        }
        if (org.gradle.internal.os.OperatingSystem.UNIX == operatingSystem) {
            return OperatingSystem.UNIX;
        }
        if (org.gradle.internal.os.OperatingSystem.WINDOWS == operatingSystem) {
            return OperatingSystem.WINDOWS;
        }
        if (org.gradle.internal.os.OperatingSystem.MAC_OS == operatingSystem) {
            return OperatingSystem.MAC_OS;
        }
        if (org.gradle.internal.os.OperatingSystem.SOLARIS == operatingSystem) {
            return OperatingSystem.SOLARIS;
        }
        if (org.gradle.internal.os.OperatingSystem.FREE_BSD == operatingSystem) {
            return OperatingSystem.FREE_BSD;
        }
        throw new GradleException("Unhandled operating system: " + operatingSystem.getName());
    }

    public BuildPlatform toBuildPlatform() {
        return BuildPlatformFactory.of(this.getArchitecture(), this.getOperatingSystem());
    }
}

