// SPDX-FileCopyrightText: Copyright (c) 2008-2013, NVIDIA Corporation. All rights reserved.
// SPDX-License-Identifier: Apache-2.0

#pragma once

#include <thrust/detail/config.h>

#if defined(_CCCL_IMPLICIT_SYSTEM_HEADER_GCC)
#  pragma GCC system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_CLANG)
#  pragma clang system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_MSVC)
#  pragma system_header
#endif // no system header
#include <thrust/iterator/iterator_traits.h>
#include <thrust/system/detail/generic/select_system.h>

// Include all active backend system implementations (generic, sequential, host and device)
#include <thrust/system/detail/generic/transform_reduce.h>
#include <thrust/system/detail/sequential/transform_reduce.h>
#include __THRUST_HOST_SYSTEM_ALGORITH_DETAIL_HEADER_INCLUDE(transform_reduce.h)
#include __THRUST_DEVICE_SYSTEM_ALGORITH_DETAIL_HEADER_INCLUDE(transform_reduce.h)

// Some build systems need a hint to know which files we could include
#if 0
#  include <thrust/system/cpp/detail/transform_reduce.h>
#  include <thrust/system/cuda/detail/transform_reduce.h>
#  include <thrust/system/omp/detail/transform_reduce.h>
#  include <thrust/system/tbb/detail/transform_reduce.h>
#endif

THRUST_NAMESPACE_BEGIN

_CCCL_EXEC_CHECK_DISABLE
template <typename DerivedPolicy,
          typename InputIterator,
          typename UnaryFunction,
          typename OutputType,
          typename BinaryFunction>
_CCCL_HOST_DEVICE OutputType transform_reduce(
  const thrust::detail::execution_policy_base<DerivedPolicy>& exec,
  InputIterator first,
  InputIterator last,
  UnaryFunction unary_op,
  OutputType init,
  BinaryFunction binary_op)
{
  _CCCL_NVTX_RANGE_SCOPE("thrust::transform_reduce");
  using thrust::system::detail::generic::transform_reduce;
  return transform_reduce(
    thrust::detail::derived_cast(thrust::detail::strip_const(exec)), first, last, unary_op, init, binary_op);
} // end transform_reduce()

template <typename InputIterator, typename UnaryFunction, typename OutputType, typename BinaryFunction>
OutputType transform_reduce(
  InputIterator first, InputIterator last, UnaryFunction unary_op, OutputType init, BinaryFunction binary_op)
{
  _CCCL_NVTX_RANGE_SCOPE("thrust::transform_reduce");
  using thrust::system::detail::generic::select_system;

  using System = typename thrust::iterator_system<InputIterator>::type;

  System system;

  return thrust::transform_reduce(select_system(system), first, last, unary_op, init, binary_op);
} // end transform_reduce()

THRUST_NAMESPACE_END
