/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.InvalidMessageDataException;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelView;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlighter;

public class HttpPanelComponentViewsManager
implements ItemListener,
MessageLocationHighlighter {
    private static final Logger logger = LogManager.getLogger(HttpPanelComponentViewsManager.class);
    private static final String VIEWS_KEY = "views";
    private static final String DEFAULT_VIEW_KEY = "defaultview";
    private static DefaultViewSelectorComparator defaultViewSelectorComparator;
    private Message message;
    private JPanel panelViews;
    private JComboBox<ViewItem> comboBoxSelectView;
    private MutableComboBoxModel<ViewItem> comboBoxModel;
    private HttpPanelView currentView;
    private List<ViewItem> enabledViews = new ArrayList<ViewItem>();
    private Map<String, ViewItem> viewItems = new HashMap<String, ViewItem>();
    private Map<String, HttpPanelView> views = new HashMap<String, HttpPanelView>();
    private List<HttpPanelDefaultViewSelector> defaultViewsSelectors = new ArrayList<HttpPanelDefaultViewSelector>();
    private String savedSelectedViewName;
    private String configurationKey;
    private String viewsConfigurationKey;
    private boolean isEditable = false;
    private Object changingComboBoxLocker;
    private boolean changingComboBox;
    private HttpPanel owner;

    public HttpPanelComponentViewsManager(String configurationKey) {
        this.configurationKey = configurationKey;
        this.viewsConfigurationKey = "";
        this.changingComboBoxLocker = new Object();
        this.changingComboBox = false;
        this.savedSelectedViewName = null;
        this.comboBoxModel = new SortedComboBoxModel<ViewItem>();
        this.comboBoxSelectView = new JComboBox<ViewItem>(this.comboBoxModel);
        this.comboBoxSelectView.addItemListener(this);
        this.panelViews = new JPanel(new CardLayout());
    }

    public HttpPanelComponentViewsManager(String configurationKey, String label) {
        this(configurationKey);
        this.comboBoxSelectView.setRenderer(new CustomDelegateListCellRenderer(this.comboBoxSelectView, label));
    }

    public HttpPanelComponentViewsManager(HttpPanel owner, String configurationKey) {
        this(configurationKey);
        this.owner = owner;
    }

    public HttpPanelComponentViewsManager(HttpPanel owner, String configurationKey, String label) {
        this(configurationKey, label);
        this.owner = owner;
    }

    public JComponent getSelectableViewsComponent() {
        return this.comboBoxSelectView;
    }

    public JPanel getViewsPanel() {
        return this.panelViews;
    }

    public void setSelected(boolean selected) {
        if (this.currentView != null) {
            this.currentView.setSelected(selected);
        }
    }

    private void switchView(String name) {
        if (this.currentView != null && this.currentView.getCaptionName().equals(name)) {
            this.currentView.setSelected(true);
            if (this.owner != null) {
                this.owner.fireMessageViewChangedEvent(this.currentView, this.currentView);
            }
            return;
        }
        HttpPanelView view = this.views.get(name);
        if (view == null) {
            logger.info("No view found with name: " + name);
            return;
        }
        HttpPanelView previousView = this.currentView;
        if (this.currentView != null) {
            this.currentView.setSelected(false);
            this.currentView.getModel().clear();
        }
        this.currentView = view;
        this.comboBoxModel.setSelectedItem(this.viewItems.get(name));
        this.currentView.getModel().setMessage(this.message);
        ((CardLayout)this.panelViews.getLayout()).show(this.panelViews, name);
        this.currentView.setSelected(true);
        if (this.owner != null) {
            this.owner.fireMessageViewChangedEvent(previousView, this.currentView);
        }
    }

    public void setMessage(Message aMessage) {
        this.message = aMessage;
        this.enableViews();
        String defaultViewName = this.getDefaultEnabledViewName();
        if (defaultViewName != null) {
            if (defaultViewName.equals(this.currentView.getName())) {
                this.currentView.getModel().setMessage(this.message);
            } else {
                this.switchView(defaultViewName);
            }
        } else if (!this.enabledViews.contains(this.viewItems.get(this.currentView.getName()))) {
            this.switchView(this.enabledViews.get(0).getConfigName());
        } else {
            this.currentView.getModel().setMessage(this.message);
        }
    }

    private void enableViews() {
        Iterator<Map.Entry<String, HttpPanelView>> it = this.views.entrySet().iterator();
        while (it.hasNext()) {
            HttpPanelView view = it.next().getValue();
            ViewItem viewItem = this.viewItems.get(view.getName());
            if (!view.isEnabled(this.message)) {
                if (!this.enabledViews.contains(viewItem)) continue;
                this.disableView(viewItem);
                continue;
            }
            if (this.enabledViews.contains(viewItem)) continue;
            this.enableView(viewItem);
        }
    }

    private String getDefaultEnabledViewName() {
        String defaultViewName = null;
        for (HttpPanelDefaultViewSelector defaultView : this.defaultViewsSelectors) {
            if (!defaultView.matchToDefaultView(this.message) || !this.enabledViews.contains(this.viewItems.get(defaultView.getViewName()))) continue;
            defaultViewName = defaultView.getViewName();
            break;
        }
        return defaultViewName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemStateChanged(ItemEvent e) {
        Object object = this.changingComboBoxLocker;
        synchronized (object) {
            if (this.changingComboBox) {
                return;
            }
        }
        if (e.getStateChange() == 1) {
            if (this.currentView == null) {
                return;
            }
            ViewItem item = (ViewItem)this.comboBoxModel.getSelectedItem();
            if (item == null || item.getConfigName().equals(this.currentView.getName())) {
                return;
            }
            try {
                this.save();
            }
            catch (InvalidMessageDataException e1) {
                this.comboBoxModel.setSelectedItem(this.viewItems.get(this.currentView.getName()));
                StringBuilder warnMessage = new StringBuilder(150);
                warnMessage.append(Constant.messages.getString("http.panel.view.warn.datainvalid"));
                String exceptionMessage = e1.getLocalizedMessage();
                if (exceptionMessage != null && !exceptionMessage.isEmpty()) {
                    warnMessage.append('\n').append(exceptionMessage);
                }
                View.getSingleton().showWarningDialog(warnMessage.toString());
                return;
            }
            this.switchView(item.getConfigName());
        }
    }

    public void save() {
        if (this.message == null || this.currentView == null) {
            return;
        }
        if (this.isEditable && this.currentView.hasChanged()) {
            this.currentView.save();
        }
    }

    public void addView(HttpPanelView view) {
        HttpPanelComponentViewsManager.validateView(view);
        String targetViewName = view.getTargetViewName();
        if (!"".equals(targetViewName) && this.views.containsKey(targetViewName)) {
            this.removeView(targetViewName);
        }
        String viewConfigName = view.getName();
        this.views.put(viewConfigName, view);
        ViewItem viewItem = new ViewItem(viewConfigName, view.getCaptionName(), view.getPosition());
        this.viewItems.put(viewConfigName, viewItem);
        this.panelViews.add((Component)view.getPane(), viewConfigName);
        view.setEditable(this.isEditable);
        view.setParentConfigurationKey(this.viewsConfigurationKey);
        if (view.isEnabled(this.message)) {
            this.enableView(viewItem);
            boolean switchView = false;
            if (this.currentView == null) {
                switchView = true;
            } else if (this.savedSelectedViewName != null) {
                if (this.savedSelectedViewName.equals(viewConfigName)) {
                    switchView = true;
                } else if (!this.savedSelectedViewName.equals(this.currentView.getName()) && this.currentView.getPosition() > view.getPosition()) {
                    switchView = true;
                }
            } else if (this.currentView.getPosition() > view.getPosition()) {
                switchView = true;
            }
            if (switchView) {
                this.switchView(viewConfigName);
            }
        }
    }

    private static void validateView(HttpPanelView view) {
        if (view == null) {
            throw new IllegalArgumentException("Attempting to add null view.");
        }
        HttpPanelComponentViewsManager.validateNonEmpty(view.getName(), "The view should have a non-null and non-empty name.", view);
        HttpPanelComponentViewsManager.validateNonEmpty(view.getCaptionName(), "The view should have a non-null and non-empty caption name.", view);
        HttpPanelComponentViewsManager.validateNonNull(view.getPane(), "The view should have a pane.", view);
        HttpPanelComponentViewsManager.validateNonNull(view.getModel(), "The view should have a model.", view);
    }

    private static void validateNonEmpty(String value, String message, HttpPanelView view) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(message + " Classname: " + view.getClass().getCanonicalName());
        }
    }

    private static void validateNonNull(Object value, String message, HttpPanelView view) {
        if (value == null) {
            throw new IllegalArgumentException(message + " Classname: " + view.getClass().getCanonicalName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableView(ViewItem viewItem) {
        this.enabledViews.add(viewItem);
        Collections.sort(this.enabledViews);
        Object object = this.changingComboBoxLocker;
        synchronized (object) {
            this.changingComboBox = true;
            this.comboBoxModel.addElement(viewItem);
            this.changingComboBox = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableView(ViewItem viewItem) {
        this.enabledViews.remove(viewItem);
        Object object = this.changingComboBoxLocker;
        synchronized (object) {
            this.changingComboBox = true;
            this.comboBoxModel.removeElement(viewItem);
            this.changingComboBox = false;
        }
    }

    public void addView(HttpPanelView view, FileConfiguration fileConfiguration) {
        this.addView(view);
        view.loadConfiguration(fileConfiguration);
    }

    public void removeView(String viewName) {
        HttpPanelView view = this.views.get(viewName);
        if (view == null) {
            return;
        }
        this.views.remove(viewName);
        this.panelViews.remove(view.getPane());
        ViewItem viewItem = this.viewItems.get(viewName);
        if (this.enabledViews.contains(viewItem)) {
            this.disableView(viewItem);
        }
        this.viewItems.remove(view.getName());
        if (viewName.equals(this.currentView.getName())) {
            if (this.enabledViews.size() > 0) {
                this.switchView(this.enabledViews.get(0).getConfigName());
            } else {
                this.currentView = null;
            }
        }
    }

    public void clearView() {
        if (this.currentView != null) {
            this.currentView.getModel().clear();
            this.setMessage(null);
        }
    }

    public void clearView(boolean enableViewSelect) {
        this.clearView();
        this.setEnableViewSelect(enableViewSelect);
    }

    public void setEnableViewSelect(boolean enableViewSelect) {
        this.comboBoxSelectView.setEnabled(enableViewSelect);
    }

    public void addDefaultViewSelector(HttpPanelDefaultViewSelector defaultViewSelector) {
        this.defaultViewsSelectors.add(defaultViewSelector);
        Collections.sort(this.defaultViewsSelectors, HttpPanelComponentViewsManager.getDefaultViewSelectorComparator());
    }

    public void removeDefaultViewSelector(String defaultViewSelectorName) {
        for (HttpPanelDefaultViewSelector defaultView : this.defaultViewsSelectors) {
            if (!defaultView.getName().equals(defaultViewSelectorName)) continue;
            this.defaultViewsSelectors.remove(defaultView);
            break;
        }
    }

    private static Comparator<HttpPanelDefaultViewSelector> getDefaultViewSelectorComparator() {
        if (defaultViewSelectorComparator == null) {
            HttpPanelComponentViewsManager.createDefaultViewSelectorComparator();
        }
        return defaultViewSelectorComparator;
    }

    private static synchronized void createDefaultViewSelectorComparator() {
        if (defaultViewSelectorComparator == null) {
            defaultViewSelectorComparator = new DefaultViewSelectorComparator();
        }
    }

    public void setConfigurationKey(String parentKey) {
        this.configurationKey = parentKey + this.configurationKey + ".";
        this.viewsConfigurationKey = this.configurationKey + VIEWS_KEY + ".";
        Iterator<HttpPanelView> it = this.views.values().iterator();
        while (it.hasNext()) {
            it.next().setParentConfigurationKey(this.viewsConfigurationKey);
        }
    }

    public void loadConfig(FileConfiguration fileConfiguration) {
        this.savedSelectedViewName = fileConfiguration.getString(this.configurationKey + DEFAULT_VIEW_KEY);
        Iterator<HttpPanelView> it = this.views.values().iterator();
        while (it.hasNext()) {
            it.next().loadConfiguration(fileConfiguration);
        }
    }

    public void saveConfig(FileConfiguration fileConfiguration) {
        if (this.currentView != null) {
            fileConfiguration.setProperty(this.configurationKey + DEFAULT_VIEW_KEY, (Object)this.currentView.getName());
        }
        Iterator<HttpPanelView> it = this.views.values().iterator();
        while (it.hasNext()) {
            it.next().saveConfiguration(fileConfiguration);
        }
    }

    public void setEditable(boolean editable) {
        if (this.isEditable != editable) {
            this.isEditable = editable;
            Iterator<HttpPanelView> it = this.views.values().iterator();
            while (it.hasNext()) {
                it.next().setEditable(editable);
            }
        }
    }

    public void highlight(SearchMatch sm) {
        if (this.currentView instanceof SearchableHttpPanelView) {
            ((SearchableHttpPanelView)((Object)this.currentView)).highlight(sm);
        } else {
            SearchableHttpPanelView searchableView = this.findSearchableView();
            if (this.currentView != null) {
                this.switchView(((HttpPanelView)((Object)searchableView)).getName());
                searchableView.highlight(sm);
            }
        }
    }

    public void search(Pattern p, List<SearchMatch> matches) {
        if (this.currentView instanceof SearchableHttpPanelView) {
            ((SearchableHttpPanelView)((Object)this.currentView)).search(p, matches);
        } else {
            SearchableHttpPanelView searchableView = this.findSearchableView();
            if (searchableView != null) {
                searchableView.search(p, matches);
            }
        }
    }

    private SearchableHttpPanelView findSearchableView() {
        SearchableHttpPanelView searchableView = null;
        for (HttpPanelView view : this.views.values()) {
            if (!view.isEnabled(this.message) || !(view instanceof SearchableHttpPanelView)) continue;
            searchableView = (SearchableHttpPanelView)((Object)view);
            break;
        }
        return searchableView;
    }

    @Override
    public boolean supports(MessageLocation location) {
        for (ViewItem item : this.enabledViews) {
            MessageLocationHighlighter highlighter;
            HttpPanelView view = this.views.get(item.getConfigName());
            if (!(view instanceof MessageLocationHighlighter) || !(highlighter = (MessageLocationHighlighter)((Object)view)).supports(location)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> classLocation) {
        for (ViewItem item : this.enabledViews) {
            MessageLocationHighlighter highlighter;
            HttpPanelView view = this.views.get(item.getConfigName());
            if (!(view instanceof MessageLocationHighlighter) || !(highlighter = (MessageLocationHighlighter)((Object)view)).supports(classLocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location) {
        if (this.currentView instanceof MessageLocationHighlighter) {
            MessageLocationHighlighter highlighter = (MessageLocationHighlighter)((Object)this.currentView);
            return highlighter.highlight(location);
        }
        return null;
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location, MessageLocationHighlight highlight) {
        if (this.currentView instanceof MessageLocationHighlighter) {
            MessageLocationHighlighter highlighter = (MessageLocationHighlighter)((Object)this.currentView);
            return highlighter.highlight(location, highlight);
        }
        return null;
    }

    @Override
    public void removeHighlight(MessageLocation location, MessageLocationHighlight highlightReference) {
        if (this.currentView instanceof MessageLocationHighlighter) {
            MessageLocationHighlighter highlighter = (MessageLocationHighlighter)((Object)this.currentView);
            highlighter.removeHighlight(location, highlightReference);
        }
    }

    public HttpPanelView setSelectedView(String viewName) {
        for (ViewItem item : this.enabledViews) {
            if (!viewName.equals(item.getConfigName())) continue;
            this.switchView(viewName);
            return this.currentView;
        }
        return null;
    }

    private static final class DefaultViewSelectorComparator
    implements Comparator<HttpPanelDefaultViewSelector>,
    Serializable {
        private static final long serialVersionUID = -1380844848294384189L;

        private DefaultViewSelectorComparator() {
        }

        @Override
        public int compare(HttpPanelDefaultViewSelector o1, HttpPanelDefaultViewSelector o2) {
            int order2;
            int order1 = o1.getOrder();
            if (order1 < (order2 = o2.getOrder())) {
                return -1;
            }
            if (order1 > order2) {
                return 1;
            }
            return 0;
        }
    }

    private static final class CustomDelegateListCellRenderer
    implements ListCellRenderer<ViewItem> {
        private ListCellRenderer<? super ViewItem> delegateRenderer;
        private JComboBox<ViewItem> comboBox;
        private String label;
        private ViewItem viewItem;

        public CustomDelegateListCellRenderer(JComboBox<ViewItem> aComboBox, String label) {
            this.delegateRenderer = aComboBox.getRenderer();
            this.comboBox = aComboBox;
            this.label = label;
            this.viewItem = new ViewItem("", "", -1);
            this.comboBox.addPropertyChangeListener("UI", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    delegateRenderer = new JComboBox().getRenderer();
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ViewItem> list, ViewItem value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index != -1) {
                return this.delegateRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            this.viewItem.name = this.label + value.name;
            return this.delegateRenderer.getListCellRendererComponent(list, this.viewItem, index, isSelected, cellHasFocus);
        }
    }

    private static final class ViewItem
    implements Comparable<ViewItem> {
        private final String configName;
        private String name;
        private final int position;

        public ViewItem(String configName, String name, int position) {
            this.configName = configName;
            this.name = name;
            this.position = position;
        }

        public String getConfigName() {
            return this.configName;
        }

        @Override
        public int compareTo(ViewItem o) {
            if (this.position < o.position) {
                return -1;
            }
            if (this.position > o.position) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            return 31 * this.configName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ViewItem other = (ViewItem)obj;
            return this.configName.equals(other.configName);
        }

        public String toString() {
            return this.name;
        }
    }
}

