/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.common;

import org.apache.commons.configuration.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public abstract class VersionedAbstractParam
extends AbstractParam {
    private final Logger logger = LogManager.getLogger(this.getClass());
    protected static final String VERSION_ATTRIBUTE = "[@version]";
    protected static final int NO_CONFIG_VERSION = -1;
    protected static final int ERROR_READING_CONFIG_VERSION = -2;

    @Override
    protected void parse() {
        this.updateConfigFile();
        this.parseImpl();
    }

    protected abstract void parseImpl();

    protected void updateConfigFile() {
        int configVersion = this.readConfigFileVersion();
        if (!this.isLatestConfigVersion(configVersion)) {
            this.updateConfigsFromVersion(configVersion);
        }
    }

    protected int readConfigFileVersion() {
        try {
            return this.getConfig().getInt(this.getConfigVersionKey(), -1);
        }
        catch (ConversionException e) {
            this.logger.error("Error while getting the version of the configurations: " + e.getMessage(), (Throwable)e);
            return -2;
        }
    }

    protected abstract String getConfigVersionKey();

    protected boolean isLatestConfigVersion(int version) {
        return version == this.getCurrentVersion();
    }

    protected abstract int getCurrentVersion();

    protected void updateConfigsFromVersion(int fileVersion) {
        if (this.isLatestConfigVersion(fileVersion)) {
            return;
        }
        if (fileVersion == -2) {
            this.logger.warn("Configurations might not be in expected state, errors might happen...");
            return;
        }
        if (fileVersion != -1) {
            if (fileVersion > this.getCurrentVersion()) {
                this.logger.warn("Configurations will not be updated, file version (v" + fileVersion + ") is greater than the version of running code (v" + this.getCurrentVersion() + "), errors might happen...");
                return;
            }
            this.logger.info("Updating configurations from v" + fileVersion + " to v" + this.getCurrentVersion());
        }
        this.updateConfigsImpl(fileVersion);
        this.getConfig().setProperty(this.getConfigVersionKey(), (Object)this.getCurrentVersion());
    }

    protected abstract void updateConfigsImpl(int var1);
}

