/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.encoder;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.extension.encoder.Base64;

@Deprecated
public class Encoder {
    private static final Logger logger = LogManager.getLogger(Encoder.class);
    private int base64EncodeOptions;
    private String base64Charset;

    public Encoder() {
        this.setBase64DoBreakLines(true);
        this.base64Charset = "UTF-8";
    }

    public String getURLEncode(String msg) {
        String result = "";
        try {
            result = URLEncoder.encode(msg, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getURLDecode(String msg) {
        String result = "";
        try {
            result = URLDecoder.decode(msg, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public byte[] getHashSHA1(byte[] buf) throws NoSuchAlgorithmException {
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        sha.update(buf);
        return sha.digest();
    }

    public byte[] getHashMD5(byte[] buf) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buf);
        return md5.digest();
    }

    public String getHexString(byte[] buf) {
        StringBuilder sb = new StringBuilder(20);
        for (int i = 0; i < buf.length; ++i) {
            int digit = buf[i] & 0xFF;
            String hexDigit = Integer.toHexString(digit).toUpperCase();
            if (hexDigit.length() == 1) {
                sb.append('0');
            }
            sb.append(hexDigit);
        }
        return sb.toString();
    }

    public String getHTMLString(String msg) {
        return StringEscapeUtils.escapeHtml((String)msg);
    }

    public String getJavaScriptString(String msg) {
        return StringEscapeUtils.escapeJavaScript((String)msg);
    }

    public byte[] getBytes(String buf) {
        byte[] result = null;
        try {
            result = buf.getBytes(this.base64Charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getBase64Encode(String msg) throws NullPointerException, IOException {
        return Base64.encodeBytes(this.getBytes(msg), this.base64EncodeOptions);
    }

    public String getBase64Decode(String msg) throws IllegalArgumentException, IOException {
        return new String(Base64.decode(msg, 0), this.base64Charset);
    }

    public String getBase64urlEncode(String msg) throws NullPointerException, IOException {
        return Base64.encodeBytes(this.getBytes(msg), this.base64EncodeOptions == 0 ? 16 : this.base64EncodeOptions | 0x10);
    }

    public String getBase64urlDecode(String msg) throws IllegalArgumentException, IOException {
        return new String(Base64.decode(msg, 16), this.base64Charset);
    }

    public String getIllegalUTF8Encode(String msg, int bytes) {
        char[] input_array = msg.toCharArray();
        if (bytes != 4 && bytes != 3) {
            bytes = 2;
        }
        StringBuilder sbResult = new StringBuilder(input_array.length * bytes * 3);
        for (char c : input_array) {
            if (bytes == 4) {
                sbResult.append('%').append(Integer.toHexString(240));
                sbResult.append('%').append(Integer.toHexString(128));
                sbResult.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | (c & 0x7F) >> 6)));
                sbResult.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | c & 0x3F)));
                continue;
            }
            if (bytes == 3) {
                sbResult.append('%').append(Integer.toHexString(224));
                sbResult.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | (c & 0x7F) >> 6)));
                sbResult.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | c & 0x3F)));
                continue;
            }
            sbResult.append('%').append(Integer.toHexString(0xFF & (byte)(0xC0 | (c & 0x7F) >> 6)));
            sbResult.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | c & 0x3F)));
        }
        return sbResult.toString();
    }

    public void setBase64DoBreakLines(boolean doBreakLines) {
        this.base64EncodeOptions = doBreakLines ? 8 : 0;
    }

    public void setBase64Charset(String charset) {
        this.base64Charset = charset;
    }
}

