/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.ice.harvest.StunCandidateHarvester;

public class StunMappingCandidateHarvester
extends MappingCandidateHarvester {
    private static final Logger logger = Logger.getLogger(StunMappingCandidateHarvester.class.getName());
    private static TransportAddress mask;
    private static TransportAddress face;
    private static boolean addressChecked;
    private static String[] stunServers;

    public StunMappingCandidateHarvester(String[] servers) {
        super(null, null);
        stunServers = servers;
        StunMappingCandidateHarvester.obtainAddresses();
    }

    public StunMappingCandidateHarvester() {
        super(null, null);
    }

    private static synchronized void obtainAddresses() {
        if (addressChecked) {
            return;
        }
        addressChecked = true;
        try {
            for (String server : stunServers) {
                TransportAddress addr;
                String[] addressAndPort = server.split(":");
                StunCandidateHarvester stunHarv = new StunCandidateHarvester(new TransportAddress(addressAndPort[0], (int)Integer.valueOf(addressAndPort[1]), Transport.UDP));
                Agent agent = new Agent();
                agent.setTrickling(false);
                agent.addCandidateHarvester(stunHarv);
                IceMediaStream stream = agent.createMediaStream("audio");
                agent.createComponent(stream, Transport.UDP, 32020, 32020, 32120);
                IceMediaStream iceMediaStream = agent.getStreams().get(0);
                mask = addr = iceMediaStream.getComponent(1).getDefaultCandidate().getTransportAddress();
                LocalCandidate candidate = iceMediaStream.getComponents().get(0).getDefaultCandidate();
                face = candidate.getHostAddress();
                agent.free();
                if (mask != null && face != null) break;
            }
            logger.info("Detected through stun local IP: " + face);
            logger.info("Detected through stun public IP: " + mask);
        }
        catch (Exception exc) {
            logger.log(Level.INFO, "We failed to obtain addresses for the following reason: ", exc);
        }
    }

    @Override
    public TransportAddress getMask() {
        if (mask == null) {
            StunMappingCandidateHarvester.obtainAddresses();
        }
        return mask;
    }

    @Override
    public TransportAddress getFace() {
        if (face == null) {
            StunMappingCandidateHarvester.obtainAddresses();
        }
        return face;
    }

    static {
        addressChecked = false;
    }
}

