#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 xmobar
version:              0.36
visibility:           public
id:                   xmobar-0.36-KyoLaJn9j3PL9uLId94OqL
key:                  xmobar-0.36-KyoLaJn9j3PL9uLId94OqL
license:              BSD-3-Clause
maintainer:           Jose A. Ortega Ruiz <jao@gnu.org>
author:               Andrea Rossato and Jose A. Ortega Ruiz
homepage:             http://xmobar.org
synopsis:             A Minimalistic Text Based Status Bar
description:
    Xmobar is a minimalistic text based status bar.

    Inspired by the Ion3 status bar, it supports similar
    features, like dynamic color management, output templates,
    and extensibility through plugins.

category:             System
abi:                  f55112ff0306c38e251e28034299fcfd
exposed:              True
exposed-modules:
    Xmobar Xmobar.Plugins.Monitors.Common.Run
    Xmobar.Plugins.Monitors.Common.Types Xmobar.Plugins.Monitors.Cpu

hidden-modules:
    Paths_xmobar Xmobar.Config.Types Xmobar.Config.Parse
    Xmobar.Run.Types Xmobar.Run.Template Xmobar.Run.Exec
    Xmobar.Run.Command Xmobar.Run.Runnable Xmobar.App.EventLoop
    Xmobar.App.Config Xmobar.App.Main Xmobar.App.Opts
    Xmobar.App.Compile Xmobar.App.Timer Xmobar.System.Utils
    Xmobar.System.StatFS Xmobar.System.Environment
    Xmobar.System.Localize Xmobar.System.Signal Xmobar.System.Kbd
    Xmobar.X11.Actions Xmobar.X11.Events Xmobar.X11.Parsers
    Xmobar.X11.Types Xmobar.X11.Text Xmobar.X11.Bitmap
    Xmobar.X11.ColorCache Xmobar.X11.Window Xmobar.X11.Draw
    Xmobar.Plugins.BufferedPipeReader Xmobar.Plugins.CommandReader
    Xmobar.Plugins.Date Xmobar.Plugins.EWMH Xmobar.Plugins.HandleReader
    Xmobar.Plugins.PipeReader Xmobar.Plugins.MarqueePipeReader
    Xmobar.Plugins.StdinReader Xmobar.Plugins.XMonadLog
    Xmobar.Plugins.Kbd Xmobar.Plugins.Locks Xmobar.Plugins.Monitors
    Xmobar.Plugins.Monitors.Batt Xmobar.Plugins.Monitors.Common
    Xmobar.Plugins.Monitors.Common.Output
    Xmobar.Plugins.Monitors.Common.Parsers
    Xmobar.Plugins.Monitors.Common.Files
    Xmobar.Plugins.Monitors.CoreTemp Xmobar.Plugins.Monitors.CpuFreq
    Xmobar.Plugins.Monitors.Disk Xmobar.Plugins.Monitors.Mem
    Xmobar.Plugins.Monitors.MultiCoreTemp
    Xmobar.Plugins.Monitors.MultiCpu Xmobar.Plugins.Monitors.Net
    Xmobar.Plugins.Monitors.Swap Xmobar.Plugins.Monitors.Thermal
    Xmobar.Plugins.Monitors.ThermalZone Xmobar.Plugins.Monitors.Top
    Xmobar.Plugins.Monitors.Uptime Xmobar.Plugins.Monitors.Bright
    Xmobar.Plugins.Monitors.CatInt Xmobar.X11.MinXft
    Xmobar.Plugins.Mail Xmobar.Plugins.MBox
    Xmobar.Plugins.Monitors.Wireless Xmobar.Plugins.Monitors.MPD
    Xmobar.Plugins.Monitors.Volume Xmobar.Plugins.Monitors.Alsa
    Xmobar.Plugins.DateZone Xmobar.Plugins.Monitors.Mpris
    Xmobar.System.DBus Xmobar.X11.XPMFile
    Xmobar.Plugins.Monitors.Weather

import-dirs:          /usr/lib/ghc-8.10.2/site-local/xmobar-0.36
library-dirs:         /usr/lib/ghc-8.10.2/site-local/xmobar-0.36
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/xmobar-0.36
hs-libraries:         HSxmobar-0.36-KyoLaJn9j3PL9uLId94OqL
extra-libraries:      Xrandr Xrender Xpm
depends:
    X11-1.9.2-CFtbnzgyUjsB8N17h5uSXU
    X11-xft-0.3.1-DdRQbhzQJNxAHIMYrZ8Smm
    alsa-core-0.5.0.1-JKR0FvUyCWbAEsD75IcPTP
    alsa-mixer-0.3.0-Df0VQbxglXOHshtZWJp76m
    async-2.2.2-6jw6YX55kENKLd5WbUwVu6 base-4.14.1.0
    bytestring-0.10.10.0 cereal-0.5.8.1-56yg04wGStN22upOSM9put
    containers-0.6.2.1 dbus-1.2.16-JXRZIUXyFHI9kUlVovxOpL
    directory-1.3.6.0
    extensible-exceptions-0.1.1.4-DY91N4N9LFmCiQpNXwJXMT
    filepath-1.4.2.1 hinotify-0.4.1-FsA0U5Vosy6GhNOZl5qgQ6
    http-client-tls-0.3.5.3-JmjUjXMBBQrFxLND03KIyi
    http-conduit-2.3.7.3-1gPhGmLd46pAQjucY9rkwt
    http-types-0.12.3-DFZTOe1tP827vA146GCQqh
    libmpd-0.9.2.0-E5xDvfx6yvc5AKObURnPPj mtl-2.2.2
    netlink-1.1.1.0-AmmkZlp3vtq5F2dgYlFJS1
    old-locale-1.0.0.7-LpTuchyagHAP7STZdm71P parsec-3.1.14.0
    parsec-numbers-0.1.0-Hylhcncw75uJ9YwzbgpREX process-1.6.9.0
    regex-compat-0.95.2.0-8jAT0ozbnzh2CxYMst7LDL stm-2.5.0.0 time-1.9.3
    timezone-olson-0.2.0-JeIfZbk6RYp1YJ2Vd1MHQh
    timezone-series-0.1.9-K4sIPHGwkPZHR3WEEyGuF5 transformers-0.5.6.2
    unix-2.7.2.2 utf8-string-1.0.1.1-G1tzxDqsWge3erFqc4Oe2R

haddock-interfaces:
    /usr/share/doc/i386-linux-ghc-8.10.2/xmobar-0.36/html/xmobar.haddock

haddock-html:         /usr/share/doc/i386-linux-ghc-8.10.2/xmobar-0.36/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

