"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const assert_1 = __importDefault(require("assert"));
const typescript_1 = __importDefault(require("typescript"));
const documents_1 = require("../../../../src/lib/documents");
const ls_config_1 = require("../../../../src/ls-config");
const plugins_1 = require("../../../../src/plugins");
const ImplementationProvider_1 = require("../../../../src/plugins/typescript/features/ImplementationProvider");
const utils_1 = require("../../../../src/utils");
const testDir = path_1.default.join(__dirname, '..');
describe('ImplementationProvider', () => {
    function getFullPath(filename) {
        return path_1.default.join(testDir, 'testfiles', 'implementation', filename);
    }
    function getUri(filename) {
        return (0, utils_1.pathToUrl)(getFullPath(filename));
    }
    function setup(filename) {
        const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
        const lsAndTsDocResolver = new plugins_1.LSAndTSDocResolver(docManager, [testDir], new ls_config_1.LSConfigManager());
        const provider = new ImplementationProvider_1.ImplementationProviderImpl(lsAndTsDocResolver);
        const filePath = getFullPath(filename);
        const document = docManager.openDocument({
            uri: (0, utils_1.pathToUrl)(filePath),
            text: typescript_1.default.sys.readFile(filePath) || ''
        });
        return { provider, document };
    }
    it('find implementations', async () => {
        const { document, provider } = setup('implementation.svelte');
        const implementations = await provider.getImplementation(document, {
            line: 3,
            character: 25
        });
        assert_1.default.deepStrictEqual(implementations, [
            {
                range: {
                    start: {
                        line: 5,
                        character: 24
                    },
                    end: {
                        line: 7,
                        character: 5
                    }
                },
                uri: getUri('implementation.svelte')
            },
            {
                range: {
                    start: {
                        line: 5,
                        character: 11
                    },
                    end: {
                        line: 7,
                        character: 5
                    }
                },
                uri: getUri('some-type.ts')
            }
        ]);
    });
    it('map implementation result of dts with declarationMap to source ', async () => {
        const { provider, document } = setup('../declaration-map/importing.svelte');
        const implementations = await provider.getImplementation(document, {
            line: 1,
            character: 13
        });
        assert_1.default.deepStrictEqual(implementations, [
            {
                range: {
                    end: { line: 1, character: 18 },
                    start: { line: 1, character: 16 }
                },
                uri: getUri('../declaration-map/declaration-map-project/index.ts')
            }
        ]);
    });
});
//# sourceMappingURL=ImplemenationProvider.test.js.map