/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.configsets;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.CreateConfigPayload;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.handler.configsets.ConfigSetAPIBase;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(method={SolrRequest.METHOD.POST}, path={"/cluster/configs"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
public class CreateConfigSetAPI
extends ConfigSetAPIBase {
    public CreateConfigSetAPI(CoreContainer coreContainer) {
        super(coreContainer);
    }

    @Command(name="create")
    public void create(PayloadObj<CreateConfigPayload> obj) throws Exception {
        CreateConfigPayload createConfigPayload = obj.get();
        if (this.configSetService.checkConfigExists(createConfigPayload.name)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet already exists: " + createConfigPayload.name);
        }
        if (!this.configSetService.checkConfigExists(createConfigPayload.baseConfigSet)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Base ConfigSet does not exist: " + createConfigPayload.baseConfigSet);
        }
        if (!ConfigSetsHandler.DISABLE_CREATE_AUTH_CHECKS.booleanValue() && !CreateConfigSetAPI.isTrusted(obj.getRequest().getUserPrincipal(), this.coreContainer.getAuthenticationPlugin()) && this.configSetService.isConfigSetTrusted(createConfigPayload.baseConfigSet)) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Can't create a configset with an unauthenticated request from a trusted baseConfigSet");
        }
        HashMap<String, Object> configsetCommandMsg = new HashMap<String, Object>();
        configsetCommandMsg.put("name", createConfigPayload.name);
        configsetCommandMsg.put("baseConfigSet", createConfigPayload.baseConfigSet);
        if (createConfigPayload.properties != null) {
            for (Map.Entry e : createConfigPayload.properties.entrySet()) {
                configsetCommandMsg.put("configSetProp." + (String)e.getKey(), e.getValue());
            }
        }
        this.runConfigSetCommand(obj.getResponse(), ConfigSetParams.ConfigSetAction.CREATE, configsetCommandMsg);
    }
}

