/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.solr.client.api.endpoint.ListAliasesApi;
import org.apache.solr.client.api.model.GetAliasByNameResponse;
import org.apache.solr.client.api.model.ListAliasesResponse;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class ListAliases
extends AdminAPIBase
implements ListAliasesApi {
    @Inject
    public ListAliases(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public ListAliasesResponse getAliases() throws Exception {
        ListAliases.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        ListAliasesResponse response = this.instantiateJerseyResponse(ListAliasesResponse.class);
        Aliases aliases = this.readAliasesFromZk();
        if (aliases != null) {
            response.aliases = aliases.getCollectionAliasMap();
            LinkedHashMap<String, Map> meta = new LinkedHashMap<String, Map>();
            for (String alias : aliases.getCollectionAliasListMap().keySet()) {
                Map collectionAliasProperties = aliases.getCollectionAliasProperties(alias);
                if (collectionAliasProperties.isEmpty()) continue;
                meta.put(alias, collectionAliasProperties);
            }
            response.properties = meta;
        }
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public GetAliasByNameResponse getAliasByName(String aliasName) throws Exception {
        ListAliases.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        GetAliasByNameResponse response = this.instantiateJerseyResponse(GetAliasByNameResponse.class);
        response.alias = aliasName;
        Aliases aliases = this.readAliasesFromZk();
        if (aliases != null) {
            response.collections = aliases.getCollectionAliasListMap().getOrDefault(aliasName, List.of());
            response.properties = aliases.getCollectionAliasProperties(aliasName);
        }
        return response;
    }

    private Aliases readAliasesFromZk() throws Exception {
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkStateReader zkStateReader = coreContainer.getZkController().getZkStateReader();
        zkStateReader.getAliasesManager().update();
        return zkStateReader.getAliases();
    }
}

