/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import javax.inject.Inject;
import org.apache.solr.client.api.endpoint.DeleteCollectionApi;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteCollection
extends AdminAPIBase
implements DeleteCollectionApi {
    @Inject
    public DeleteCollection(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse deleteCollection(String collectionName, Boolean followAliases, String asyncId) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        DeleteCollection.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = DeleteCollection.createRemoteMessage(collectionName, followAliases, asyncId);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.DELETE, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        if (asyncId != null) {
            response.requestId = asyncId;
            return response;
        }
        response.successfulSubResponsesByNodeName = remoteResponse.getResponse().get("success");
        response.failedSubResponsesByNodeName = remoteResponse.getResponse().get("failure");
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, Boolean followAliases, String asyncId) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.DELETE.toLower());
        remoteMessage.put("name", collectionName);
        if (followAliases != null) {
            remoteMessage.put("followAliases", followAliases);
        }
        if (asyncId != null) {
            remoteMessage.put("async", asyncId);
        }
        return new ZkNodeProps(remoteMessage);
    }
}

