/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.BackupCoreAPI;
import org.apache.solr.handler.api.V2ApiUtils;

class BackupCoreOp
implements CoreAdminHandler.CoreAdminOp {
    BackupCoreOp() {
    }

    @Override
    public boolean isExpensive() {
        return true;
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        BackupCoreAPI.BackupCoreRequestBody backupCoreRequestBody = new BackupCoreAPI.BackupCoreRequestBody();
        backupCoreRequestBody.repository = params.get("repository");
        backupCoreRequestBody.location = params.get("location");
        backupCoreRequestBody.commitName = params.get("commitName");
        String cname = params.required().get("core");
        backupCoreRequestBody.backupName = this.parseBackupName(params);
        boolean incremental = this.isIncrementalBackup(params);
        if (incremental) {
            backupCoreRequestBody.shardBackupId = params.required().get("shardBackupId");
            backupCoreRequestBody.prevShardBackupId = params.get("prevShardBackupId", null);
            backupCoreRequestBody.incremental = true;
        }
        BackupCoreAPI backupCoreAPI = new BackupCoreAPI(it.handler.coreContainer, it.req, it.rsp, it.handler.coreAdminAsyncTracker);
        try {
            SolrJerseyResponse response = backupCoreAPI.createBackup(cname, backupCoreRequestBody);
            SimpleOrderedMap namedList = new SimpleOrderedMap();
            V2ApiUtils.squashIntoNamedListWithoutHeader((NamedList<Object>)namedList, response);
            it.rsp.addResponse(namedList);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to backup core=" + cname + " because " + e, (Throwable)e);
        }
    }

    private ShardBackupId parseShardBackupId(SolrParams params) {
        if (this.isIncrementalBackup(params)) {
            return ShardBackupId.from(params.required().get("shardBackupId"));
        }
        return null;
    }

    private String parseBackupName(SolrParams params) {
        if (this.isIncrementalBackup(params)) {
            return null;
        }
        return params.required().get("name");
    }

    private boolean isIncrementalBackup(SolrParams params) {
        return params.getBool("incremental", true);
    }
}

