!* Copyright (c) Lawrence Livermore National Security, LLC and other Conduit
!* Project developers. See top-level LICENSE AND COPYRIGHT files for dates and
!* other details. No copyright assignment is required to contribute to Conduit.


!------------------------------------------------------------------------------
! file: conduit_fortran_bitwidth_style_types.inc
!------------------------------------------------------------------------------

!------------------------------------------------------------------------------
!------------------------------------------------------------------------------

!------------------------------------------------------------------------------
! generic types
!------------------------------------------------------------------------------
#define F_CONDUIT_EMPTY_ID  0
#define F_CONDUIT_OBJECT_ID 1
#define F_CONDUIT_LIST_ID   2
!------------------------------------------------------------------------------
! signed integer types
!------------------------------------------------------------------------------
#define F_CONDUIT_INT8_ID  3
#define F_CONDUIT_INT16_ID 4
#define F_CONDUIT_INT32_ID 5
#define F_CONDUIT_INT64_ID 6
!------------------------------------------------------------------------------
! unsigned integer types
!------------------------------------------------------------------------------
#define F_CONDUIT_UINT8_ID  7
#define F_CONDUIT_UINT16_ID 8
#define F_CONDUIT_UINT32_ID 9
#define F_CONDUIT_UINT64_ID 10
!------------------------------------------------------------------------------
! floating point integer types
!------------------------------------------------------------------------------
#define F_CONDUIT_FLOAT32_ID 11
#define F_CONDUIT_FLOAT64_ID 12
!------------------------------------------------------------------------------
! string  types 
!------------------------------------------------------------------------------
#define  F_CONDUIT_CHAR8_STR_ID 13


!------------------------------------------------------------------------------
! -- bitwidth style signed integer types --
!------------------------------------------------------------------------------
#define F_CONDUIT_INT8_NATIVE_NAME  "signed char"
#define F_CONDUIT_INT16_NATIVE_NAME "signed short"
#define F_CONDUIT_INT32_NATIVE_NAME "signed int"
#define F_CONDUIT_INT64_NATIVE_NAME "signed long long"

!------------------------------------------------------------------------------
! -- bitwidth style unsigned integer types --
!------------------------------------------------------------------------------
#define F_CONDUIT_UINT8_NATIVE_NAME  "unsigned char"
#define F_CONDUIT_UINT16_NATIVE_NAME "unsigned short"
#define F_CONDUIT_UINT32_NATIVE_NAME "unsigned int"
#define F_CONDUIT_UINT64_NATIVE_NAME "unsigned long long"


!------------------------------------------------------------------------------
! -- bitwidth style floating point types
!------------------------------------------------------------------------------
#define F_CONDUIT_FLOAT32_NATIVE_NAME "float"
#define F_CONDUIT_FLOAT64_NATIVE_NAME "double"

!------------------------------------------------------------------------------
! -- c style signed integer type maps --
!------------------------------------------------------------------------------
#define F_CONDUIT_NATIVE_SIGNED_CHAR_ID  3
#define F_CONDUIT_NATIVE_SIGNED_SHORT_ID 4
#define F_CONDUIT_NATIVE_SIGNED_INT_ID   5
#define F_CONDUIT_NATIVE_SIGNED_LONG_ID  5

!------------------------------------------------------------------------------
! -- c style unsigned integer type maps --
!------------------------------------------------------------------------------
#define F_CONDUIT_NATIVE_UNSIGNED_CHAR_ID  7
#define F_CONDUIT_NATIVE_UNSIGNED_SHORT_ID 8
#define F_CONDUIT_NATIVE_UNSIGNED_INT_ID   9
#define F_CONDUIT_NATIVE_UNSIGNED_LONG_ID  9

!------------------------------------------------------------------------------
! -- c style integer type maps --
!------------------------------------------------------------------------------
#if (CHAR_MIN==0)
#define F_CONDUIT_NATIVE_CHAR_ID  7
#else 
#define F_CONDUIT_NATIVE_CHAR_ID  3
#endif
#define F_CONDUIT_NATIVE_SHORT_ID 4
#define F_CONDUIT_NATIVE_INT_ID   5
#define F_CONDUIT_NATIVE_LONG_ID  5

!------------------------------------------------------------------------------
! -- c style floating point type maps --
!------------------------------------------------------------------------------
#define F_CONDUIT_NATIVE_FLOAT_ID  11
#define F_CONDUIT_NATIVE_DOUBLE_ID 12

!------------------------------------------------------------------------------
! Bit-width type map sanity checks
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------
! check that we were able to resolve all of the bitwidth style types we want
! to support
!------------------------------------------------------------------------------

!-----------------------------------------------------------------------------
!signed ints
#ifndef F_CONDUIT_INT8_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to int8
#endif

#ifndef F_CONDUIT_INT16_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to int16
#endif

#ifndef F_CONDUIT_INT32_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to int32
#endif

#ifndef F_CONDUIT_INT64_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to int64
#endif

!-----------------------------------------------------------------------------
! unsigned ints
#ifndef F_CONDUIT_UINT8_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to uint8
#endif

#ifndef F_CONDUIT_UINT16_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to uint16
#endif

#ifndef F_CONDUIT_UINT32_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to uint32
#endif

#ifndef F_CONDUIT_UINT64_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to uint64
#endif

!-----------------------------------------------------------------------------
! floating points numbers
#ifndef F_CONDUIT_FLOAT32_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to float32
#endif

#ifndef F_CONDUIT_FLOAT64_NATIVE_NAME
#error Bitwidth Style Types: no native type found that maps to float64
#endif

!------------------------------------------------------------------------------
! Index Types
!------------------------------------------------------------------------------

! use a 64-bit index, unless CONDUIT_INDEX_32 is defined.
#ifdef CONDUIT_INDEX_32
#define F_CONDUIT_INDEX_ID  F_CONDUIT_INT32_ID
#else
#define F_CONDUIT_INDEX_ID  F_CONDUIT_INT64_ID
#endif 

!-----------------------------------------------------------------------------
!End Bit-width type map sanity checks
!-----------------------------------------------------------------------------


