---
discourse: 13021
---

(networking)=
# Networking

```{only} diataxis
The following how-to guides cover common operations related to networking.

How to create and configure a network:
```

```{filtered-toctree}
:titlesonly:

:diataxis:Create a network </howto/network_create>
:diataxis:Configure a network </howto/network_configure>
```

```{only} diataxis
How to configure specific networking features:
```

```{filtered-toctree}
:titlesonly:

:diataxis:Configure as BGP server </howto/network_bgp>
:diataxis:Configure network ACLs </howto/network_acls>
:diataxis:Configure forwards </howto/network_forwards>
:diataxis:Configure network zones </howto/network_zones>
```

```{only} diataxis
How to configure specific networking features (managed bridge networks only):
```

```{filtered-toctree}
:titlesonly:

:diataxis:Configure your firewall </howto/network_bridge_firewalld>
:diataxis:Integrate with resolved </howto/network_bridge_resolved>
```

```{only} diataxis
How to configure specific networking features (OVN networks only):
```

```{filtered-toctree}
:titlesonly:

:diataxis:Set up OVN </howto/network_ovn_setup>
:diataxis:Configure load balancers </howto/network_load_balancers>
:diataxis:Configure peer routing </howto/network_ovn_peers>
```

```{only} diataxis
How to troubleshoot your networking setup:
```

```{filtered-toctree}
:titlesonly:

:diataxis:Display IPAM information </howto/network_ipam>
```

## Related topics

```{only} diataxis
{{networks_exp}}

{{networks_ref}}
```

```{filtered-toctree}
:maxdepth: 1

:topical:/explanation/networks
:topical:Create a network </howto/network_create>
:topical:Configure a network </howto/network_configure>
:topical:Configure network ACLs </howto/network_acls>
:topical:Configure network forwards </howto/network_forwards>
:topical:Configure network zones </howto/network_zones>
:topical:Configure LXD as BGP server </howto/network_bgp>
:topical:Display LXD IPAM information </howto/network_ipam>
:topical:/reference/networks
```
