/*
 * Decompiled with CFR 0.152.
 */
package jnr.x86asm;

import jnr.x86asm.Operand;
import jnr.x86asm.RELOC_MODE;

public final class Immediate
extends Operand {
    private final long value;
    private final boolean isUnsigned;
    private final RELOC_MODE relocMode;

    public Immediate(long value2, boolean isUnsigned) {
        super(3, 0);
        this.value = value2;
        this.isUnsigned = isUnsigned;
        this.relocMode = RELOC_MODE.RELOC_NONE;
    }

    public long value() {
        return this.value;
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return (short)this.value;
    }

    public final int intValue() {
        return (int)this.value;
    }

    public final long longValue() {
        return this.value;
    }

    public final boolean isUnsigned() {
        return this.isUnsigned;
    }

    RELOC_MODE relocMode() {
        return this.relocMode;
    }

    public static final Immediate imm(long value2) {
        return value2 >= -128L && value2 <= 127L ? Cache.cache[128 + (int)value2] : new Immediate(value2, false);
    }

    public static final Immediate uimm(long value2) {
        return new Immediate(value2, true);
    }

    private static final class Cache {
        static final Immediate[] cache = new Immediate[256];

        private Cache() {
        }

        static {
            for (int i2 = 0; i2 < cache.length; ++i2) {
                Cache.cache[i2] = new Immediate((long)(i2 - 128), false);
            }
        }
    }
}

