/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.threadpool;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.config.PropertySetter;
import org.apache.commons.jcs3.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs3.utils.threadpool.PoolConfiguration;

public class ThreadPoolManager {
    private static final Log log = LogManager.getLog(ThreadPoolManager.class);
    private PoolConfiguration defaultConfig;
    private PoolConfiguration defaultSchedulerConfig;
    private static final String PROP_NAME_ROOT = "thread_pool";
    private static final String DEFAULT_PROP_NAME_ROOT = "thread_pool.default";
    private static final String PROP_NAME_SCHEDULER_ROOT = "scheduler_pool";
    private static final String DEFAULT_PROP_NAME_SCHEDULER_ROOT = "scheduler_pool.default";
    private static volatile Properties props;
    private final ConcurrentHashMap<String, ExecutorService> pools = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ScheduledExecutorService> schedulerPools = new ConcurrentHashMap();

    private ThreadPoolManager() {
        this.configure();
    }

    public ExecutorService createPool(PoolConfiguration config, String threadNamePrefix) {
        return this.createPool(config, threadNamePrefix, 5);
    }

    public ExecutorService createPool(PoolConfiguration config, String threadNamePrefix, int threadPriority) {
        LinkedBlockingQueue<Runnable> queue = null;
        if (config.isUseBoundary()) {
            log.debug("Creating a Bounded Buffer to use for the pool");
            queue = new LinkedBlockingQueue(config.getBoundarySize());
        } else {
            log.debug("Creating a non bounded Linked Queue to use for the pool");
            queue = new LinkedBlockingQueue<Runnable>();
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(config.getStartUpSize(), config.getMaximumPoolSize(), (long)config.getKeepAliveTime(), TimeUnit.MILLISECONDS, queue, new DaemonThreadFactory(threadNamePrefix, threadPriority));
        switch (config.getWhenBlockedPolicy()) {
            case ABORT: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                break;
            }
            case RUN: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                break;
            }
            case WAIT: {
                throw new RuntimeException("POLICY_WAIT no longer supported");
            }
            case DISCARDOLDEST: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                break;
            }
        }
        pool.prestartAllCoreThreads();
        return pool;
    }

    public ScheduledExecutorService createSchedulerPool(PoolConfiguration config, String threadNamePrefix, int threadPriority) {
        return Executors.newScheduledThreadPool(config.getMaximumPoolSize(), new DaemonThreadFactory(threadNamePrefix, threadPriority));
    }

    public static ThreadPoolManager getInstance() {
        return ThreadPoolManagerHolder.INSTANCE;
    }

    public static void dispose() {
        Map.Entry<String, ExecutorService> entry;
        Iterator<Map.Entry<String, ExecutorService>> i = ThreadPoolManager.getInstance().pools.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            try {
                entry.getValue().shutdownNow();
            }
            catch (Throwable t) {
                log.warn("Failed to close pool {0}", entry.getKey(), t);
            }
            i.remove();
        }
        i = ThreadPoolManager.getInstance().schedulerPools.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            try {
                ((ScheduledExecutorService)entry.getValue()).shutdownNow();
            }
            catch (Throwable t) {
                log.warn("Failed to close pool {0}", entry.getKey(), t);
            }
            i.remove();
        }
    }

    public ExecutorService getExecutorService(String name) {
        return this.pools.computeIfAbsent(name, key -> {
            log.debug("Creating pool for name [{0}]", key);
            PoolConfiguration config = this.loadConfig("thread_pool." + key, this.defaultConfig);
            return this.createPool(config, "JCS-ThreadPoolManager-" + key + "-");
        });
    }

    public ScheduledExecutorService getSchedulerPool(String name) {
        return this.schedulerPools.computeIfAbsent(name, key -> {
            log.debug("Creating scheduler pool for name [{0}]", key);
            PoolConfiguration config = this.loadConfig("scheduler_pool." + key, this.defaultSchedulerConfig);
            return this.createSchedulerPool(config, "JCS-ThreadPoolManager-" + key + "-", 5);
        });
    }

    protected Set<String> getPoolNames() {
        return this.pools.keySet();
    }

    public static void setProps(Properties props) {
        ThreadPoolManager.props = props;
    }

    private void configure() {
        log.debug("Initializing ThreadPoolManager");
        if (props == null) {
            log.warn("No configuration settings found. Using hardcoded default values for all pools.");
            props = new Properties();
        }
        this.defaultConfig = this.loadConfig(DEFAULT_PROP_NAME_ROOT, new PoolConfiguration());
        this.defaultSchedulerConfig = this.loadConfig(DEFAULT_PROP_NAME_SCHEDULER_ROOT, new PoolConfiguration());
    }

    private PoolConfiguration loadConfig(String root, PoolConfiguration defaultPoolConfiguration) {
        PoolConfiguration config = defaultPoolConfiguration.clone();
        PropertySetter.setProperties(config, props, root + ".");
        log.debug("{0} PoolConfiguration = {1}", root, config);
        return config;
    }

    private static class ThreadPoolManagerHolder {
        static final ThreadPoolManager INSTANCE = new ThreadPoolManager();

        private ThreadPoolManagerHolder() {
        }
    }
}

