#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 singletons
version:              3.0
visibility:           public
id:                   singletons-3.0-4cGrZZ4UJGgTaIRie6PUW
key:                  singletons-3.0-4cGrZZ4UJGgTaIRie6PUW
license:              BSD-3-Clause
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:
    Richard Eisenberg <rae@cs.brynmawr.edu>, Jan Stolarek <jan.stolarek@p.lodz.pl>

stability:            experimental
homepage:             http://www.github.com/goldfirere/singletons
synopsis:             Basic singleton types and definitions
description:
    @singletons@ contains the basic types and definitions needed to support
    dependently typed programming techniques in Haskell. This library was
    originally presented in /Dependently Typed Programming with Singletons/,
    published at the Haskell Symposium, 2012.
    (<https://cs.brynmawr.edu/~rae/papers/2012/singletons/paper.pdf>)

    @singletons@ is intended to be a small, foundational library on which other
    projects can build. As such, @singletons@ has a minimal dependency
    footprint and supports GHCs dating back to GHC 8.0. For more information,
    consult the @singletons@
    @<https://github.com/goldfirere/singletons/blob/master/README.md README>@.

    You may also be interested in the following related libraries:

    * The @singletons-th@ library defines Template Haskell functionality that
    allows /promotion/ of term-level functions to type-level equivalents and
    /singling/ functions to dependently typed equivalents.

    * The @singletons-base@ library uses @singletons-th@ to define promoted and
    singled functions from the @base@ library, including the "Prelude".

category:             Dependent Types
abi:                  7bfb50d5efe7b6f9a882b25387603708
exposed:              True
exposed-modules:
    Data.Singletons Data.Singletons.Decide Data.Singletons.ShowSing
    Data.Singletons.Sigma

import-dirs:          /usr/lib/ghc-8.10.5/site-local/singletons-3.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/singletons-3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/singletons-3.0
hs-libraries:         HSsingletons-3.0-4cGrZZ4UJGgTaIRie6PUW
depends:              base-4.14.2.0
haddock-interfaces:   /usr/share/doc/haskell-singletons/html/singletons.haddock
haddock-html:         /usr/share/doc/haskell-singletons/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

