#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hyphenation
version:              0.8.1
visibility:           public
id:                   hyphenation-0.8.1-CRR1XN4rskx9TRD9fzlV2x
key:                  hyphenation-0.8.1-CRR1XN4rskx9TRD9fzlV2x
license:              BSD-2-Clause
copyright:            (C) 2012-2019 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/hyphenation
synopsis:             Configurable Knuth-Liang hyphenation
description:
    Configurable Knuth-Liang hyphenation

    Uses the UTF8 encoded hyphenation patterns provided by
    hyph-utf8 from
    <http://www.ctan.org/tex-archive/language/hyph-utf8>

    Usage:

    >>> hyphenate english_US "supercalifragilisticexpialadocious"
    ["su","per","cal","ifrag","ilis","tic","ex","pi","al","ado","cious"]

    >>> hyphenate english_US "hyphenation"
    ["hy","phen","ation"]

    >>> hyphenate icelandic "va\240lahei\240avegavinnuverkf\230rageymslusk\250r"
    ["va\240la","hei\240a","vega","vinnu","verk","f\230ra","geymslu","sk\250r"]

category:             Text
abi:                  288f553b5cebf2c931291f3b1f2ac84b
exposed:              True
exposed-modules:
    Text.Hyphenation Text.Hyphenation.Exception
    Text.Hyphenation.Hyphenator Text.Hyphenation.Language
    Text.Hyphenation.Pattern

hidden-modules:
    Text.Hyphenation.ByteStringLazyCompat Paths_hyphenation

import-dirs:          /usr/lib/ghc-8.10.5/site-local/hyphenation-0.8.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hyphenation-0.8.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/hyphenation-0.8.1
hs-libraries:         HShyphenation-0.8.1-CRR1XN4rskx9TRD9fzlV2x
depends:
    base-4.14.2.0 bytestring-0.10.12.0 containers-0.6.4.1 text-1.2.4.1
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    zlib-0.6.2.3-iLt2uLes3HGCCNqRD7eNI

haddock-interfaces:   /usr/share/doc/haskell-hyphenation/html/hyphenation.haddock
haddock-html:         /usr/share/doc/haskell-hyphenation/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

