/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ColumnSelectionPanel
extends JPanel {
    private final Map<ColumnSelectionModel, JCheckBox> checkBoxes = new HashMap<ColumnSelectionModel, JCheckBox>();

    public ColumnSelectionPanel(ColumnSelectionModel[] columns) {
        this.setLayout(new GridBagLayout());
        this.init(columns);
    }

    public static void showColumnSelectionPopup(ColumnSelectionModel[] columns, Component c) {
        JPopupMenu popup = new JPopupMenu();
        for (int col = 0; col < columns.length; ++col) {
            final ColumnSelectionModel column = columns[col];
            final JCheckBoxMenuItem checkBox = new JCheckBoxMenuItem();
            checkBox.setText(column.getName());
            checkBox.setSelected(column.isSelected());
            checkBox.setEnabled(column.isEnabled());
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    column.setSelected(checkBox.isSelected());
                }
            });
            popup.add(checkBox);
        }
        popup.show(c, 8, 8);
    }

    public static void showColumnSelectionDialog(ColumnSelectionModel[] columns, String dialogTitle) {
        ColumnSelectionPanel panel = new ColumnSelectionPanel(columns);
        int res = JOptionPane.showConfirmDialog(null, panel, dialogTitle, 2);
        if (res == 0) {
            panel.applyDialogChanges();
        }
    }

    public void init(ColumnSelectionModel[] columns) {
        int i = 0;
        int j = 0;
        int width = 1;
        int rows = columns.length / width;
        for (int col = 0; col < columns.length; ++col) {
            if (i >= rows) {
                i = 0;
            }
            ColumnSelectionModel column = columns[col];
            JCheckBox checkBox = new JCheckBox();
            checkBox.setText(column.getName());
            checkBox.setSelected(column.isSelected());
            checkBox.setEnabled(column.isEnabled());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = ++j;
            gridBagConstraints.gridy = i + i;
            gridBagConstraints.insets = new Insets(0, 12, 0, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)checkBox, gridBagConstraints);
            this.checkBoxes.put(column, checkBox);
            ++i;
        }
    }

    private void applyDialogChanges() {
        for (ColumnSelectionModel columnModel : this.checkBoxes.keySet()) {
            JCheckBox checkBox = this.checkBoxes.get(columnModel);
            columnModel.setSelected(checkBox.isSelected());
        }
    }

    public static interface ColumnSelectionModel {
        public boolean isEnabled();

        public boolean isSelected();

        public void setSelected(boolean var1);

        public String getName();
    }
}

