/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.favorites.Actions;
import org.netbeans.modules.favorites.FavoritesNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.util.Mutex;

public final class Favorites {
    private static Favorites INSTANCE;
    private static final Logger LOG;

    public static synchronized Favorites getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new Favorites();
        }
        return INSTANCE;
    }

    public synchronized void add(FileObject ... toAdd) throws NullPointerException, DataObjectNotFoundException {
        if (toAdd.length == 0) {
            return;
        }
        this.addInternal(toAdd);
    }

    public synchronized boolean selectWithAddition(FileObject fo) throws DataObjectNotFoundException {
        DataShadow obj = this.findShadow(fo);
        boolean result = false;
        if (obj == null) {
            DataShadow[] shadows = this.addInternal(fo);
            if (shadows.length > 0) {
                obj = shadows[0];
            }
            boolean bl = result = obj != null;
        }
        if (obj != null) {
            DataShadow fObj = obj;
            Mutex.EVENT.readAccess(() -> Favorites.lambda$selectWithAddition$0((DataObject)fObj));
        }
        return result;
    }

    public synchronized boolean isInFavorites(FileObject fo) {
        return this.findShadow(fo) != null;
    }

    public String toString() {
        return "Favorites: " + this.getFavoriteRoots().toString();
    }

    void clearBrokenShadows() throws IOException {
        DataObject[] arr;
        DataFolder f = FavoritesNode.getFolder();
        for (DataObject obj : arr = f.getChildren()) {
            if (obj instanceof DataShadow) continue;
            obj.delete();
        }
    }

    private DataShadow findShadow(FileObject fo) {
        DataObject[] arr;
        DataFolder f = FavoritesNode.getFolder();
        for (DataObject arr1 : arr = f.getChildren()) {
            DataShadow obj;
            if (!(arr1 instanceof DataShadow) || !fo.equals((obj = (DataShadow)arr1).getOriginal().getPrimaryFile())) continue;
            return obj;
        }
        return null;
    }

    public synchronized List<FileObject> getFavoriteRoots() {
        DataFolder f = FavoritesNode.getFolder();
        DataObject[] arr = f.getChildren();
        ArrayList<FileObject> ret = new ArrayList<FileObject>(arr.length);
        for (DataObject obj : arr) {
            if (!(obj instanceof DataShadow)) continue;
            ret.add(((DataShadow)obj).getOriginal().getPrimaryFile());
        }
        return ret;
    }

    public synchronized void remove(FileObject ... toRemove) throws IOException, NullPointerException {
        DataObject[] arr;
        DataFolder f = FavoritesNode.getFolder();
        for (DataObject obj : arr = f.getChildren()) {
            if (!(obj instanceof DataShadow)) continue;
            FileObject root = ((DataShadow)obj).getOriginal().getPrimaryFile();
            for (FileObject rem : toRemove) {
                if (!rem.equals(root)) continue;
                obj.delete();
            }
        }
    }

    private DataShadow[] addInternal(FileObject ... toAdd) throws DataObjectNotFoundException {
        DataFolder f = FavoritesNode.getFolder();
        DataShadow[] createdDOs = this.createShadows(f, toAdd);
        Actions.Add.reorderAfterAddition(f, f.getChildren(), Arrays.asList(createdDOs));
        return createdDOs;
    }

    private DataShadow[] createShadows(DataFolder favorites, FileObject[] toAdd) throws DataObjectNotFoundException, IllegalArgumentException {
        ArrayList<DataShadow> createdDO = new ArrayList<DataShadow>(toAdd.length);
        for (FileObject toAdd1 : toAdd) {
            DataObject obj;
            if (this.isInFavorites(toAdd1) || (obj = DataObject.find((FileObject)toAdd1)) == null) continue;
            try {
                createdDO.add(obj.createShadow(favorites));
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }
        return createdDO.toArray(new DataShadow[createdDO.size()]);
    }

    private static /* synthetic */ void lambda$selectWithAddition$0(DataObject fObj) {
        Actions.Add.selectAfterAddition(fObj);
    }

    static {
        LOG = Logger.getLogger(Favorites.class.getName());
    }
}

