/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class ReadyMessage
extends AttributeMessage {
    public static final String TAG = "ready";
    private static final String PLAYER_TAG = "player";
    private static final String VALUE_TAG = "value";

    public ReadyMessage(Player player, boolean ready) {
        super(TAG, PLAYER_TAG, player == null ? null : player.getId(), VALUE_TAG, String.valueOf(ready));
    }

    public ReadyMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, PLAYER_TAG, VALUE_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player player = this.getPlayer(game);
        boolean ready = this.getValue();
        if (player == null) {
            return;
        }
        this.pgc(freeColClient).readyHandler(player, ready);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            logger.warning("Ready from unknown player.");
        }
        boolean ready = this.getValue();
        return this.pgc(freeColServer).ready(serverPlayer, ready);
    }

    public Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(PLAYER_TAG), Player.class);
    }

    public boolean getValue() {
        return this.getBooleanAttribute(VALUE_TAG, Boolean.FALSE);
    }
}

