﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace AppSync
{
namespace Model
{

  /**
   * <p>Describes the ARNs and IDs of associations, Merged APIs, and source
   * APIs.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/SourceApiAssociationSummary">AWS
   * API Reference</a></p>
   */
  class SourceApiAssociationSummary
  {
  public:
    AWS_APPSYNC_API SourceApiAssociationSummary();
    AWS_APPSYNC_API SourceApiAssociationSummary(Aws::Utils::Json::JsonView jsonValue);
    AWS_APPSYNC_API SourceApiAssociationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_APPSYNC_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline const Aws::String& GetAssociationId() const{ return m_associationId; }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline void SetAssociationId(const Aws::String& value) { m_associationIdHasBeenSet = true; m_associationId = value; }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline void SetAssociationId(Aws::String&& value) { m_associationIdHasBeenSet = true; m_associationId = std::move(value); }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline void SetAssociationId(const char* value) { m_associationIdHasBeenSet = true; m_associationId.assign(value); }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline SourceApiAssociationSummary& WithAssociationId(const Aws::String& value) { SetAssociationId(value); return *this;}

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline SourceApiAssociationSummary& WithAssociationId(Aws::String&& value) { SetAssociationId(std::move(value)); return *this;}

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline SourceApiAssociationSummary& WithAssociationId(const char* value) { SetAssociationId(value); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline const Aws::String& GetAssociationArn() const{ return m_associationArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline bool AssociationArnHasBeenSet() const { return m_associationArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline void SetAssociationArn(const Aws::String& value) { m_associationArnHasBeenSet = true; m_associationArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline void SetAssociationArn(Aws::String&& value) { m_associationArnHasBeenSet = true; m_associationArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline void SetAssociationArn(const char* value) { m_associationArnHasBeenSet = true; m_associationArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline SourceApiAssociationSummary& WithAssociationArn(const Aws::String& value) { SetAssociationArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline SourceApiAssociationSummary& WithAssociationArn(Aws::String&& value) { SetAssociationArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline SourceApiAssociationSummary& WithAssociationArn(const char* value) { SetAssociationArn(value); return *this;}


    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline const Aws::String& GetSourceApiId() const{ return m_sourceApiId; }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline bool SourceApiIdHasBeenSet() const { return m_sourceApiIdHasBeenSet; }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline void SetSourceApiId(const Aws::String& value) { m_sourceApiIdHasBeenSet = true; m_sourceApiId = value; }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline void SetSourceApiId(Aws::String&& value) { m_sourceApiIdHasBeenSet = true; m_sourceApiId = std::move(value); }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline void SetSourceApiId(const char* value) { m_sourceApiIdHasBeenSet = true; m_sourceApiId.assign(value); }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline SourceApiAssociationSummary& WithSourceApiId(const Aws::String& value) { SetSourceApiId(value); return *this;}

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline SourceApiAssociationSummary& WithSourceApiId(Aws::String&& value) { SetSourceApiId(std::move(value)); return *this;}

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline SourceApiAssociationSummary& WithSourceApiId(const char* value) { SetSourceApiId(value); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>
     */
    inline const Aws::String& GetSourceApiArn() const{ return m_sourceApiArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>
     */
    inline bool SourceApiArnHasBeenSet() const { return m_sourceApiArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>
     */
    inline void SetSourceApiArn(const Aws::String& value) { m_sourceApiArnHasBeenSet = true; m_sourceApiArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>
     */
    inline void SetSourceApiArn(Aws::String&& value) { m_sourceApiArnHasBeenSet = true; m_sourceApiArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>
     */
    inline void SetSourceApiArn(const char* value) { m_sourceApiArnHasBeenSet = true; m_sourceApiArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>
     */
    inline SourceApiAssociationSummary& WithSourceApiArn(const Aws::String& value) { SetSourceApiArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>
     */
    inline SourceApiAssociationSummary& WithSourceApiArn(Aws::String&& value) { SetSourceApiArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>
     */
    inline SourceApiAssociationSummary& WithSourceApiArn(const char* value) { SetSourceApiArn(value); return *this;}


    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline const Aws::String& GetMergedApiId() const{ return m_mergedApiId; }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline bool MergedApiIdHasBeenSet() const { return m_mergedApiIdHasBeenSet; }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline void SetMergedApiId(const Aws::String& value) { m_mergedApiIdHasBeenSet = true; m_mergedApiId = value; }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline void SetMergedApiId(Aws::String&& value) { m_mergedApiIdHasBeenSet = true; m_mergedApiId = std::move(value); }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline void SetMergedApiId(const char* value) { m_mergedApiIdHasBeenSet = true; m_mergedApiId.assign(value); }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline SourceApiAssociationSummary& WithMergedApiId(const Aws::String& value) { SetMergedApiId(value); return *this;}

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline SourceApiAssociationSummary& WithMergedApiId(Aws::String&& value) { SetMergedApiId(std::move(value)); return *this;}

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline SourceApiAssociationSummary& WithMergedApiId(const char* value) { SetMergedApiId(value); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline const Aws::String& GetMergedApiArn() const{ return m_mergedApiArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline bool MergedApiArnHasBeenSet() const { return m_mergedApiArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline void SetMergedApiArn(const Aws::String& value) { m_mergedApiArnHasBeenSet = true; m_mergedApiArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline void SetMergedApiArn(Aws::String&& value) { m_mergedApiArnHasBeenSet = true; m_mergedApiArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline void SetMergedApiArn(const char* value) { m_mergedApiArnHasBeenSet = true; m_mergedApiArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline SourceApiAssociationSummary& WithMergedApiArn(const Aws::String& value) { SetMergedApiArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline SourceApiAssociationSummary& WithMergedApiArn(Aws::String&& value) { SetMergedApiArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline SourceApiAssociationSummary& WithMergedApiArn(const char* value) { SetMergedApiArn(value); return *this;}


    /**
     * <p>The description field.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }

    /**
     * <p>The description field.</p>
     */
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }

    /**
     * <p>The description field.</p>
     */
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }

    /**
     * <p>The description field.</p>
     */
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }

    /**
     * <p>The description field.</p>
     */
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }

    /**
     * <p>The description field.</p>
     */
    inline SourceApiAssociationSummary& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}

    /**
     * <p>The description field.</p>
     */
    inline SourceApiAssociationSummary& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}

    /**
     * <p>The description field.</p>
     */
    inline SourceApiAssociationSummary& WithDescription(const char* value) { SetDescription(value); return *this;}

  private:

    Aws::String m_associationId;
    bool m_associationIdHasBeenSet = false;

    Aws::String m_associationArn;
    bool m_associationArnHasBeenSet = false;

    Aws::String m_sourceApiId;
    bool m_sourceApiIdHasBeenSet = false;

    Aws::String m_sourceApiArn;
    bool m_sourceApiArnHasBeenSet = false;

    Aws::String m_mergedApiId;
    bool m_mergedApiIdHasBeenSet = false;

    Aws::String m_mergedApiArn;
    bool m_mergedApiArnHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
