info = {
    "name": "sr-Cyrl",
    "date_order": "DMY",
    "january": [
        "јан",
        "јануар"
    ],
    "february": [
        "феб",
        "фебруар"
    ],
    "march": [
        "мар",
        "март"
    ],
    "april": [
        "апр",
        "април"
    ],
    "may": [
        "мај"
    ],
    "june": [
        "јун"
    ],
    "july": [
        "јул"
    ],
    "august": [
        "авг",
        "август"
    ],
    "september": [
        "сеп",
        "септембар"
    ],
    "october": [
        "окт",
        "октобар"
    ],
    "november": [
        "нов",
        "новембар"
    ],
    "december": [
        "дец",
        "децембар"
    ],
    "monday": [
        "пон",
        "понедељак"
    ],
    "tuesday": [
        "уто",
        "уторак"
    ],
    "wednesday": [
        "сре",
        "среда"
    ],
    "thursday": [
        "чет",
        "четвртак"
    ],
    "friday": [
        "пет",
        "петак"
    ],
    "saturday": [
        "суб",
        "субота"
    ],
    "sunday": [
        "нед",
        "недеља"
    ],
    "am": [
        "пре подне"
    ],
    "pm": [
        "по подне"
    ],
    "year": [
        "г",
        "год",
        "година"
    ],
    "month": [
        "м",
        "мес",
        "месец"
    ],
    "week": [
        "н",
        "нед",
        "недеља"
    ],
    "day": [
        "д",
        "дан"
    ],
    "hour": [
        "сат",
        "ч"
    ],
    "minute": [
        "мин",
        "минут"
    ],
    "second": [
        "с",
        "сек",
        "секунд"
    ],
    "relative-type": {
        "0 day ago": [
            "данас"
        ],
        "0 hour ago": [
            "овог сата"
        ],
        "0 minute ago": [
            "овог минута"
        ],
        "0 month ago": [
            "овог месеца"
        ],
        "0 second ago": [
            "сада"
        ],
        "0 week ago": [
            "ове недеље"
        ],
        "0 year ago": [
            "ове године"
        ],
        "1 day ago": [
            "јуче"
        ],
        "1 month ago": [
            "прошлог месеца"
        ],
        "1 week ago": [
            "прошле недеље"
        ],
        "1 year ago": [
            "прошле године"
        ],
        "in 1 day": [
            "сутра"
        ],
        "in 1 month": [
            "следећег месеца"
        ],
        "in 1 week": [
            "следеће недеље"
        ],
        "in 1 year": [
            "следеће године"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "пре (\\d+[.,]?\\d*) д",
            "пре (\\d+[.,]?\\d*) дана"
        ],
        "\\1 hour ago": [
            "пре (\\d+[.,]?\\d*) сата",
            "пре (\\d+[.,]?\\d*) сати",
            "пре (\\d+[.,]?\\d*) ч"
        ],
        "\\1 minute ago": [
            "пре (\\d+[.,]?\\d*) мин",
            "пре (\\d+[.,]?\\d*) минута"
        ],
        "\\1 month ago": [
            "пре (\\d+[.,]?\\d*) м",
            "пре (\\d+[.,]?\\d*) мес",
            "пре (\\d+[.,]?\\d*) месеца",
            "пре (\\d+[.,]?\\d*) месеци"
        ],
        "\\1 second ago": [
            "пре (\\d+[.,]?\\d*) с",
            "пре (\\d+[.,]?\\d*) сек",
            "пре (\\d+[.,]?\\d*) секунде",
            "пре (\\d+[.,]?\\d*) секунди"
        ],
        "\\1 week ago": [
            "пре (\\d+[.,]?\\d*) н",
            "пре (\\d+[.,]?\\d*) нед",
            "пре (\\d+[.,]?\\d*) недеља",
            "пре (\\d+[.,]?\\d*) недеље"
        ],
        "\\1 year ago": [
            "пре (\\d+[.,]?\\d*) г",
            "пре (\\d+[.,]?\\d*) год",
            "пре (\\d+[.,]?\\d*) година",
            "пре (\\d+[.,]?\\d*) године"
        ],
        "in \\1 day": [
            "за (\\d+[.,]?\\d*) д",
            "за (\\d+[.,]?\\d*) дан",
            "за (\\d+[.,]?\\d*) дана"
        ],
        "in \\1 hour": [
            "за (\\d+[.,]?\\d*) сат",
            "за (\\d+[.,]?\\d*) сати",
            "за (\\d+[.,]?\\d*) ч"
        ],
        "in \\1 minute": [
            "за (\\d+[.,]?\\d*) мин",
            "за (\\d+[.,]?\\d*) минут",
            "за (\\d+[.,]?\\d*) минута"
        ],
        "in \\1 month": [
            "за (\\d+[.,]?\\d*) м",
            "за (\\d+[.,]?\\d*) мес",
            "за (\\d+[.,]?\\d*) месец",
            "за (\\d+[.,]?\\d*) месеци"
        ],
        "in \\1 second": [
            "за (\\d+[.,]?\\d*) с",
            "за (\\d+[.,]?\\d*) сек",
            "за (\\d+[.,]?\\d*) секунди",
            "за (\\d+[.,]?\\d*) секунду"
        ],
        "in \\1 week": [
            "за (\\d+[.,]?\\d*) н",
            "за (\\d+[.,]?\\d*) нед",
            "за (\\d+[.,]?\\d*) недеља",
            "за (\\d+[.,]?\\d*) недељу"
        ],
        "in \\1 year": [
            "за (\\d+[.,]?\\d*) г",
            "за (\\d+[.,]?\\d*) год",
            "за (\\d+[.,]?\\d*) година",
            "за (\\d+[.,]?\\d*) годину"
        ]
    },
    "locale_specific": {
        "sr-Cyrl-BA": {
            "name": "sr-Cyrl-BA",
            "september": [
                "септ"
            ],
            "tuesday": [
                "ут"
            ],
            "wednesday": [
                "ср",
                "сриједа"
            ],
            "sunday": [
                "недјеља"
            ],
            "am": [
                "прије подне"
            ]
        },
        "sr-Cyrl-ME": {
            "name": "sr-Cyrl-ME",
            "september": [
                "септ"
            ],
            "tuesday": [
                "ут"
            ],
            "wednesday": [
                "ср",
                "сриједа"
            ],
            "sunday": [
                "недјеља"
            ],
            "am": [
                "прије подне"
            ]
        },
        "sr-Cyrl-XK": {
            "name": "sr-Cyrl-XK",
            "september": [
                "септ"
            ],
            "tuesday": [
                "ут"
            ],
            "wednesday": [
                "ср"
            ]
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
