﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpaces {
namespace Model {
class CreateConnectClientAddInResult {
 public:
  AWS_WORKSPACES_API CreateConnectClientAddInResult() = default;
  AWS_WORKSPACES_API CreateConnectClientAddInResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACES_API CreateConnectClientAddInResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The client add-in identifier.</p>
   */
  inline const Aws::String& GetAddInId() const { return m_addInId; }
  template <typename AddInIdT = Aws::String>
  void SetAddInId(AddInIdT&& value) {
    m_addInIdHasBeenSet = true;
    m_addInId = std::forward<AddInIdT>(value);
  }
  template <typename AddInIdT = Aws::String>
  CreateConnectClientAddInResult& WithAddInId(AddInIdT&& value) {
    SetAddInId(std::forward<AddInIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateConnectClientAddInResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_addInId;

  Aws::String m_requestId;
  bool m_addInIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
