/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.ConnectionRefusedException;
import com.zeroc.Ice.FacetNotExistException;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectNotExistException;
import com.zeroc.IceGridGUI.LiveActions;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.MetricsViewEditor;
import com.zeroc.IceGridGUI.LiveDeployment.TreeNode;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceMX.MetricsAdminPrx;
import com.zeroc.IceMX.MetricsFailures;
import java.awt.Component;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;

class MetricsView
extends TreeNode {
    private String _name;
    private MetricsAdminPrx _admin;
    private MetricsViewEditor _editor;
    private boolean _enabled;
    private static JPopupMenu _popup;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _enabledIcon;
    private static Icon _disabledIcon;

    @Override
    public Editor getEditor() {
        return this._editor;
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[25];
        actions[21] = !this._enabled;
        actions[22] = this._enabled;
        return actions;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _enabledIcon = Utils.getIcon("/icons/16x16/metrics.png");
            _disabledIcon = Utils.getIcon("/icons/16x16/metrics_disabled.png");
        }
        Icon icon = this._enabled ? _enabledIcon : _disabledIcon;
        _cellRenderer.setLeafIcon(icon);
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    MetricsView(TreeNode parent, String name, MetricsAdminPrx admin, boolean enabled) {
        super(parent, name);
        this._name = name;
        this._admin = admin;
        this._editor = new MetricsViewEditor(this.getRoot());
        this._enabled = enabled;
    }

    @Override
    public void enableMetricsView(boolean enabled) {
        if (this._admin != null) {
            if (enabled) {
                this._admin.enableMetricsViewAsync(this._name).whenComplete((result, ex) -> {
                    if (ex == null) {
                        SwingUtilities.invokeLater(() -> {
                            this._enabled = true;
                            this.getRoot().getTreeModel().nodeChanged(this);
                            this.getRoot().getCoordinator().showActions(this);
                            if (this.getRoot().getTree().getLastSelectedPathComponent() == this) {
                                MetricsViewEditor.startRefresh(this);
                            }
                        });
                    } else {
                        MetricsViewEditor.stopRefresh();
                        SwingUtilities.invokeLater(() -> {
                            if (!(ex instanceof ObjectNotExistException || ex instanceof ConnectionRefusedException || ex instanceof CommunicatorDestroyedException)) {
                                ex.printStackTrace();
                                JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), "Error: " + ex.toString(), "Error", 0);
                            }
                        });
                    }
                });
            } else {
                this._admin.disableMetricsViewAsync(this._name).whenComplete((result, ex) -> {
                    if (ex == null) {
                        SwingUtilities.invokeLater(() -> {
                            this._enabled = false;
                            this._editor.show(this, null, 0L);
                            this.getRoot().getTreeModel().nodeChanged(this);
                            this.getRoot().getCoordinator().showActions(this);
                            if (this.getRoot().getTree().getLastSelectedPathComponent() == this) {
                                MetricsViewEditor.stopRefresh();
                            }
                        });
                    } else {
                        MetricsViewEditor.stopRefresh();
                        SwingUtilities.invokeLater(() -> {
                            if (!(ex instanceof ObjectNotExistException || ex instanceof ConnectionRefusedException || ex instanceof CommunicatorDestroyedException)) {
                                ex.printStackTrace();
                                JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), "Error: " + ex.toString(), "Error", 0);
                            }
                        });
                    }
                });
            }
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    MetricsAdminPrx getMetricsAdmin() {
        return this._admin;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        LiveActions la = this.getCoordinator().getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(21));
            _popup.add(la.get(22));
        }
        la.setTarget(this);
        return _popup;
    }

    public CompletableFuture<MetricsFailures> fetchMetricsFailures(String map, String id) {
        if (this._admin != null) {
            try {
                return this._admin.getMetricsFailuresAsync(this._name, map, id);
            }
            catch (LocalException e) {
                JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), "Error: " + e.toString(), "Error", 0);
            }
        }
        return null;
    }

    public void fetchMetricsView() {
        if (this._admin != null) {
            try {
                this._admin.getMetricsViewAsync(this._name).whenComplete((result, ex) -> {
                    if (ex == null) {
                        SwingUtilities.invokeLater(() -> this._editor.show(this, result.returnValue, result.timestamp));
                    } else {
                        MetricsViewEditor.stopRefresh();
                        SwingUtilities.invokeLater(() -> {
                            if (!(ex instanceof ObjectNotExistException || ex instanceof ConnectionRefusedException || ex instanceof FacetNotExistException || ex instanceof CommunicatorDestroyedException)) {
                                ex.printStackTrace();
                                JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), "Error: " + ex.toString(), "Error", 0);
                            }
                        });
                    }
                });
            }
            catch (CommunicatorDestroyedException communicatorDestroyedException) {
            }
            catch (LocalException e) {
                MetricsViewEditor.stopRefresh();
                JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), "Error: " + e.toString(), "Error", 0);
            }
        }
    }
}

