/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import joptsimple.AlternativeLongOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NoArgumentOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecVisitor;
import joptsimple.OptionalArgumentOptionSpec;
import joptsimple.ParserRules;
import joptsimple.RequiredArgumentOptionSpec;
import joptsimple.internal.Classes;
import joptsimple.internal.ColumnarData;
import joptsimple.internal.Strings;

class OptionParserHelpFormatter
implements OptionSpecVisitor {
    private final ColumnarData grid = new ColumnarData(new String[]{"Option", "Description"});
    static /* synthetic */ Class class$java$lang$String;

    OptionParserHelpFormatter() {
    }

    String format(Map options) {
        if (options.isEmpty()) {
            return "No options specified";
        }
        this.grid.clear();
        TreeSet sorted = new TreeSet(new OptionSpecComparator());
        sorted.addAll(options.values());
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            ((OptionSpec)iter.next()).accept(this);
        }
        return this.grid.format();
    }

    void addHelpLineFor(OptionSpec spec, String additionalInfo) {
        this.grid.addRow(new Object[]{this.createOptionDisplay(spec) + additionalInfo, spec.description()});
    }

    public void visit(NoArgumentOptionSpec spec) {
        this.addHelpLineFor(spec, "");
    }

    public void visit(RequiredArgumentOptionSpec spec) {
        this.visit(spec, '<', '>');
    }

    public void visit(OptionalArgumentOptionSpec spec) {
        this.visit(spec, '[', ']');
    }

    private void visit(ArgumentAcceptingOptionSpec spec, char begin, char end) {
        String argDescription = spec.argumentDescription();
        String argType = OptionParserHelpFormatter.nameOfArgumentType(spec);
        StringBuffer collector = new StringBuffer();
        if (argType.length() > 0) {
            collector.append(argType);
            if (argDescription.length() > 0) {
                collector.append(": ").append(argDescription);
            }
        } else if (argDescription.length() > 0) {
            collector.append(argDescription);
        }
        String helpLine = collector.length() == 0 ? "" : ' ' + Strings.surround(collector.toString(), begin, end);
        this.addHelpLineFor(spec, helpLine);
    }

    public void visit(AlternativeLongOptionSpec spec) {
        String argDescription = spec.argumentDescription();
        this.addHelpLineFor(spec, ' ' + Strings.surround(argDescription, '<', '>'));
    }

    private String createOptionDisplay(OptionSpec spec) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = spec.options().iterator();
        while (iter.hasNext()) {
            String option = (String)iter.next();
            buffer.append(option.length() > 1 ? "--" : ParserRules.HYPHEN);
            buffer.append(option);
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private static String nameOfArgumentType(ArgumentAcceptingOptionSpec spec) {
        Class argType = spec.argumentType();
        return (class$java$lang$String == null ? (class$java$lang$String = OptionParserHelpFormatter.class$("java.lang.String")) : class$java$lang$String).equals(argType) ? "" : Classes.shortNameOf(argType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class OptionSpecComparator
    implements Comparator {
        private OptionSpecComparator() {
        }

        public int compare(Object first, Object second) {
            OptionSpec firstSpec = (OptionSpec)first;
            OptionSpec secondSpec = (OptionSpec)second;
            if (firstSpec.equals(secondSpec)) {
                return 0;
            }
            List firstOptions = firstSpec.options();
            List secondOptions = secondSpec.options();
            return ((String)firstOptions.get(0)).compareTo((String)secondOptions.get(0));
        }
    }
}

