/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.deprecation;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLEntity;

public class DeprecateEntityInfo<E extends OWLEntity> {
    @Nonnull
    private final E entityToDeprecate;
    @Nonnull
    private final String reasonForDeprecation;
    @Nullable
    private final OWLAnnotationValue deprecationCode;
    @Nullable
    private final E replacementEntity;
    @Nonnull
    private final Set<E> alternateEntities = new HashSet();

    public DeprecateEntityInfo(@Nonnull E entityToDeprecate, @Nullable E replacementEntity, @Nonnull String reasonForDeprecation, @Nonnull Set<E> alternateEntities, @Nullable OWLAnnotationValue deprecationCode) {
        this.entityToDeprecate = (OWLEntity)Preconditions.checkNotNull(entityToDeprecate);
        this.replacementEntity = replacementEntity;
        this.reasonForDeprecation = (String)Preconditions.checkNotNull((Object)reasonForDeprecation);
        this.deprecationCode = deprecationCode;
        this.alternateEntities.addAll((Collection)Preconditions.checkNotNull(alternateEntities));
    }

    @Nonnull
    public E getEntityToDeprecate() {
        return this.entityToDeprecate;
    }

    @Nonnull
    public String getReasonForDeprecation() {
        return this.reasonForDeprecation;
    }

    @Nonnull
    public Optional<E> getReplacementEntity() {
        return Optional.ofNullable(this.replacementEntity);
    }

    @Nonnull
    public Set<E> getAlternateEntities() {
        return new HashSet<E>(this.alternateEntities);
    }

    @Nonnull
    public Optional<OWLAnnotationValue> getDeprecationCode() {
        return Optional.ofNullable(this.deprecationCode);
    }
}

