/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.listener;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumnModel;
import mediathek.config.MVConfig;
import mediathek.tool.table.MVTable;

public class BeobTableHeader
extends MouseAdapter {
    private final MVTable tabelle;
    private final String[] columns;
    private final boolean[] spaltenAnzeigen;
    private final int[] ausblenden;
    private final int[] button;
    private final boolean icon;
    private final MVConfig.Configs configs;
    private JCheckBoxMenuItem[] box;

    public BeobTableHeader(MVTable tabelle, boolean[] spalten, int[] aausblenden, int[] bbutton, boolean icon, MVConfig.Configs configs) {
        this.tabelle = tabelle;
        this.icon = icon;
        this.spaltenAnzeigen = spalten;
        this.ausblenden = aausblenden;
        this.configs = configs;
        this.button = bbutton;
        TableColumnModel colModel = tabelle.getTableHeader().getColumnModel();
        int colCount = colModel.getColumnCount();
        this.columns = new String[colCount];
        for (int index = 0; index < colCount; ++index) {
            this.columns[index] = (String)colModel.getColumn(index).getHeaderValue();
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.showMenu(arg0);
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.showMenu(arg0);
        }
    }

    private boolean immer(int i) {
        for (int ii : this.ausblenden) {
            if (i != ii) continue;
            return true;
        }
        return false;
    }

    private void showMenu(MouseEvent evt) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.box = new JCheckBoxMenuItem[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.immer(i)) continue;
            this.box[i] = new JCheckBoxMenuItem(this.columns[i]);
            this.box[i].setSelected(this.anzeigen(i));
            this.box[i].addActionListener(e -> this.setSpalten());
            jPopupMenu.add(this.box[i]);
        }
        if (this.button.length > 0) {
            jPopupMenu.addSeparator();
            JCheckBoxMenuItem item2 = new JCheckBoxMenuItem("Button anzeigen");
            item2.setSelected(this.anzeigen(this.button[0]));
            item2.addActionListener(e -> {
                for (int i : this.button) {
                    this.setSpalten(i, item2.isSelected());
                }
            });
            jPopupMenu.add(item2);
        }
        if (this.icon) {
            jPopupMenu.addSeparator();
            JCheckBoxMenuItem item3 = new JCheckBoxMenuItem("Sendericons anzeigen");
            item3.setSelected(this.tabelle.showSenderIcons());
            item3.addActionListener(e -> {
                this.tabelle.setShowIcon(item3.isSelected());
                this.setSpalten();
            });
            jPopupMenu.add(item3);
            JCheckBoxMenuItem item2 = new JCheckBoxMenuItem("kleine Sendericons anzeigen");
            item2.setSelected(this.tabelle.useSmallSenderIcons);
            if (!this.tabelle.showSenderIcons()) {
                item2.setEnabled(false);
            } else {
                item2.addActionListener(e -> {
                    this.tabelle.useSmallSenderIcons = item2.isSelected();
                    this.setSpalten();
                });
            }
            jPopupMenu.add(item2);
        }
        jPopupMenu.addSeparator();
        JCheckBoxMenuItem itemBr = new JCheckBoxMenuItem("Zeilen umbrechen");
        itemBr.setSelected(this.tabelle.isLineBreak());
        itemBr.addActionListener(e -> {
            this.tabelle.setLineBreak(itemBr.isSelected());
            MVConfig.add(this.configs, Boolean.toString(itemBr.isSelected()));
            this.setSpalten();
        });
        jPopupMenu.add(itemBr);
        jPopupMenu.addSeparator();
        JMenuItem item1 = new JMenuItem("Spalten zur\u00fccksetzen");
        item1.addActionListener(e -> this.tabelle.resetTabelle());
        jPopupMenu.add(item1);
        jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private boolean anzeigen(int i) {
        return this.spaltenAnzeigen == null || this.spaltenAnzeigen[i];
    }

    private void setSpalten() {
        for (int i = 0; i < this.box.length; ++i) {
            if (this.box[i] == null) continue;
            this.spaltenAnzeigen[i] = this.box[i].isSelected();
        }
        this.tabelle.spaltenEinAus();
        this.tabelle.setHeight();
    }

    private void setSpalten(int k, boolean anz) {
        this.spaltenAnzeigen[k] = anz;
        this.tabelle.spaltenEinAus();
    }
}

