/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.controller.starter.Start;
import mediathek.gui.messages.GeoStateChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MVSenderIconCache;
import mediathek.tool.cellrenderer.CellRendererBase;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;

public class CellRendererBaseWithStart
extends CellRendererBase {
    private static final long serialVersionUID = 1659689253119935809L;
    protected final Configuration config = ApplicationConfiguration.getConfiguration();
    protected boolean geoMelden;

    public CellRendererBaseWithStart(MVSenderIconCache cache) {
        super(cache);
        Daten.getInstance().getMessageBus().subscribe(this);
        this.geoMelden = this.config.getBoolean("geo.report", false);
    }

    @Handler
    private void handleGeoStateChanged(GeoStateChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.geoMelden = this.config.getBoolean("geo.report", false);
        });
    }

    protected void setBackgroundColor(Component c, Start s2, boolean isSelected) {
        if (s2 != null) {
            Color color = null;
            switch (s2.status) {
                case 1: {
                    if (isSelected) {
                        color = MVColor.DOWNLOAD_WAIT_SEL.color;
                        break;
                    }
                    color = MVColor.DOWNLOAD_WAIT.color;
                    break;
                }
                case 2: {
                    if (isSelected) {
                        color = MVColor.DOWNLOAD_RUN_SEL.color;
                        break;
                    }
                    color = MVColor.DOWNLOAD_RUN.color;
                    break;
                }
                case 3: {
                    if (isSelected) {
                        color = MVColor.DOWNLOAD_FERTIG_SEL.color;
                        break;
                    }
                    color = MVColor.DOWNLOAD_FERTIG.color;
                    break;
                }
                case 4: {
                    color = isSelected ? MVColor.DOWNLOAD_FEHLER_SEL.color : MVColor.DOWNLOAD_FEHLER.color;
                }
            }
            c.setBackground(color);
        }
    }

    protected void setGeoblockingBackgroundColor(Component c, boolean isSelected) {
        Color color = isSelected ? MVColor.FILM_GEOBLOCK_BACKGROUND_SEL.color : MVColor.FILM_GEOBLOCK_BACKGROUND.color;
        c.setBackground(color);
    }

    protected void setupGeoblockingBackground(Component c, String geo, boolean isSelected) {
        if (!geo.isEmpty() && !geo.contains(this.config.getString("geo.location"))) {
            this.setGeoblockingBackgroundColor(c, isSelected);
        }
    }
}

