/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jruby.ir.dataflow.analyses.LoadLocalVarPlacementProblem;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementProblem;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;

public class AddLocalVarLoadStoreInstructions
extends CompilerPass {
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = Arrays.asList(LiveVariableAnalysis.class);

    @Override
    public String getLabel() {
        return "Add Local Variable Load/Store Instructions";
    }

    @Override
    public String getShortLabel() {
        return "Add LVar L/S";
    }

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Object execute(FullInterpreterContext fic, Object ... data2) {
        StoreLocalVarPlacementProblem slvp = new StoreLocalVarPlacementProblem();
        if (!fic.isDynamicScopeEliminated() || fic.reuseParentDynScope()) {
            HashMap<Operand, Operand> varRenameMap = new HashMap<Operand, Operand>();
            slvp.setup(fic);
            slvp.compute_MOP_Solution();
            slvp.addStores(varRenameMap);
            LoadLocalVarPlacementProblem llvp = new LoadLocalVarPlacementProblem();
            llvp.setup(fic);
            llvp.compute_MOP_Solution();
            llvp.addLoads(varRenameMap);
            for (BasicBlock b2 : fic.getCFG().getBasicBlocks()) {
                for (Instr i2 : b2.getInstrs()) {
                    i2.renameVars(varRenameMap);
                }
            }
            new LiveVariableAnalysis().invalidate(fic);
        }
        fic.getDataFlowProblems().put("Placement of local-var stores", slvp);
        return slvp;
    }

    @Override
    public Object previouslyRun(FullInterpreterContext fic) {
        return fic.getDataFlowProblems().get("Placement of local-var stores");
    }

    @Override
    public boolean invalidate(FullInterpreterContext fic) {
        super.invalidate(fic);
        fic.getDataFlowProblems().put("Placement of local-var stores", null);
        return true;
    }
}

