/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.rbconfig;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.util.Platform;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.load.Library;
import org.jruby.util.NormalizedFile;
import org.jruby.util.SafePropertyAccessor;

@JRubyModule(name={"Config"})
public class RbConfigLibrary
implements Library {
    private static final String RUBY_DARWIN = "darwin";
    private static final String RUBY_LINUX = "linux";
    private static final String RUBY_WIN32 = "mswin32";
    private static final String RUBY_SOLARIS = "solaris";
    private static final String RUBY_FREEBSD = "freebsd";
    private static final String RUBY_DRAGONFLYBSD = "dragonflybsd";
    private static final String RUBY_AIX = "aix";
    private static String normalizedHome;
    public static final Map<String, String> RUBY_OS_NAMES;
    private static final boolean IS_64_BIT;

    public static String getOSName() {
        if (org.jruby.platform.Platform.IS_LINUX) {
            return RUBY_LINUX;
        }
        if (org.jruby.platform.Platform.IS_MAC) {
            return RUBY_DARWIN;
        }
        if (org.jruby.platform.Platform.IS_WINDOWS) {
            return RUBY_WIN32;
        }
        String osName = SafePropertyAccessor.getProperty("os.name");
        String rubyName = RUBY_OS_NAMES.get(osName);
        return rubyName == null ? osName : rubyName;
    }

    public static String getArchitecture() {
        String architecture = org.jruby.platform.Platform.ARCH;
        if (architecture == null) {
            architecture = "unknown";
        }
        if ("amd64".equals(architecture)) {
            architecture = "x86_64";
        }
        return architecture;
    }

    public static String getRuntimeVerStr(Ruby runtime2) {
        return "2.5";
    }

    public static String getNormalizedHome(Ruby runtime2) {
        normalizedHome = runtime2.getJRubyHome();
        if (normalizedHome == null && Ruby.isSecurityRestricted()) {
            normalizedHome = "SECURITY RESTRICTED";
        }
        return normalizedHome;
    }

    public static String getLibDir(Ruby runtime2) {
        String libdir = SafePropertyAccessor.getProperty("jruby.lib");
        if (libdir == null) {
            String home2 = RbConfigLibrary.getNormalizedHome(runtime2);
            libdir = home2.startsWith("uri:") ? home2 + "/lib" : RbConfigLibrary.newFile(home2, "lib").getPath();
        } else {
            try {
                libdir = RbConfigLibrary.newFile(libdir).getCanonicalPath();
            }
            catch (IOException e) {
                libdir = RbConfigLibrary.newFile(libdir).getAbsolutePath();
            }
        }
        return libdir;
    }

    public static String getVendorDirGeneral(Ruby runtime2) {
        return RbConfigLibrary.newFile(SafePropertyAccessor.getProperty("vendor.dir.general", RbConfigLibrary.getLibDir(runtime2))).getPath();
    }

    public static String getSiteDirGeneral(Ruby runtime2) {
        return RbConfigLibrary.newFile(SafePropertyAccessor.getProperty("site.dir.general", RbConfigLibrary.getLibDir(runtime2))).getPath();
    }

    public static Boolean isSiteVendorSame(Ruby runtime2) {
        return RbConfigLibrary.getVendorDirGeneral(runtime2).equals(RbConfigLibrary.getSiteDirGeneral(runtime2));
    }

    public static String getRubygemsDir(Ruby runtime2) {
        return SafePropertyAccessor.getProperty("vendor.dir.rubygems", null);
    }

    public static String getRubySharedLibDir(Ruby runtime2) {
        return RbConfigLibrary.newFile(RbConfigLibrary.getVendorDirGeneral(runtime2), "ruby/shared").getPath();
    }

    public static String getRubyLibDir(Ruby runtime2) {
        return RbConfigLibrary.getRubyLibDirFor(runtime2, "stdlib");
    }

    public static String getRubyLibDirFor(Ruby runtime2, String runtimeVerStr) {
        return RbConfigLibrary.newFile(RbConfigLibrary.getVendorDirGeneral(runtime2), String.format("ruby/%s", runtimeVerStr)).getPath();
    }

    public static String getArchDir(Ruby runtime2) {
        return RbConfigLibrary.getRubyLibDir(runtime2);
    }

    public static String getVendorDir(Ruby runtime2) {
        return RbConfigLibrary.newFile(RbConfigLibrary.getRubyLibDir(runtime2), "vendor_ruby").getPath();
    }

    public static String getVendorLibDir(Ruby runtime2) {
        return RbConfigLibrary.getVendorDir(runtime2);
    }

    public static String getVendorArchDir(Ruby runtime2) {
        return RbConfigLibrary.getVendorDir(runtime2);
    }

    public static String getSiteDir(Ruby runtime2) {
        return RbConfigLibrary.newFile(RbConfigLibrary.getSiteDirGeneral(runtime2), String.format("ruby/%s/site_ruby", RbConfigLibrary.getRuntimeVerStr(runtime2))).getPath();
    }

    public static String getSiteLibDir(Ruby runtime2) {
        return RbConfigLibrary.getSiteDir(runtime2);
    }

    public static String getSiteArchDir(Ruby runtime2) {
        return RbConfigLibrary.getSiteDir(runtime2);
    }

    public static String getSysConfDir(Ruby runtime2) {
        return RbConfigLibrary.newFile(RbConfigLibrary.getNormalizedHome(runtime2), "etc").getPath();
    }

    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyModule rbConfig = runtime2.defineModule("RbConfig");
        normalizedHome = RbConfigLibrary.getNormalizedHome(runtime2);
        rbConfig.setConstant("TOPDIR", RubyString.newString(runtime2, normalizedHome));
        RubyString destDir = RubyString.newEmptyString(runtime2);
        rbConfig.setConstant("DESTDIR", destDir);
        RubyHash CONFIG = new RubyHash(runtime2, 48);
        CONFIG.fastASetCheckString(runtime2, runtime2.newString("DESTDIR"), destDir);
        String[] versionParts = "2.5.7".split("\\.");
        String major = versionParts[0];
        String minor = versionParts[1];
        String teeny = versionParts[2];
        RbConfigLibrary.setConfig(context, CONFIG, "MAJOR", major);
        RbConfigLibrary.setConfig(context, CONFIG, "MINOR", minor);
        RbConfigLibrary.setConfig(context, CONFIG, "TEENY", teeny);
        RbConfigLibrary.setConfig(context, CONFIG, "ruby_version", major + '.' + minor + ".0");
        RbConfigLibrary.setConfig(context, CONFIG, "arch", "universal-java" + System.getProperty("java.specification.version"));
        String binDir = SafePropertyAccessor.getProperty("jruby.bindir");
        if (binDir == null) {
            binDir = RbConfigLibrary.newFile(normalizedHome, "bin").getPath();
        }
        RbConfigLibrary.setConfig(context, CONFIG, "bindir", binDir);
        RbConfigLibrary.setConfig(context, CONFIG, "RUBY_INSTALL_NAME", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(context, CONFIG, "RUBYW_INSTALL_NAME", org.jruby.platform.Platform.IS_WINDOWS ? "jrubyw.exe" : RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(context, CONFIG, "ruby_install_name", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(context, CONFIG, "rubyw_install_name", org.jruby.platform.Platform.IS_WINDOWS ? "jrubyw.exe" : RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(context, CONFIG, "SHELL", RbConfigLibrary.jrubyShell());
        RbConfigLibrary.setConfig(context, CONFIG, "prefix", normalizedHome);
        RbConfigLibrary.setConfig(context, CONFIG, "exec_prefix", normalizedHome);
        String osName = RbConfigLibrary.getOSName();
        String arch = RbConfigLibrary.getArchitecture();
        String vendor = SafePropertyAccessor.getProperty("java.vendor");
        RbConfigLibrary.setConfig(context, CONFIG, "host_os", osName);
        RbConfigLibrary.setConfig(context, CONFIG, "host_vendor", vendor);
        RbConfigLibrary.setConfig(context, CONFIG, "host_cpu", arch);
        String host = String.format("%s-%s-%s", osName, vendor, arch);
        RbConfigLibrary.setConfig(context, CONFIG, "host", host);
        RbConfigLibrary.setConfig(context, CONFIG, "host_alias", host);
        RbConfigLibrary.setConfig(context, CONFIG, "target_os", osName);
        RbConfigLibrary.setConfig(context, CONFIG, "target_cpu", arch);
        String jrubyJarFile = "jruby.jar";
        URL jrubyPropertiesUrl = Ruby.getClassLoader().getResource("/org/jruby/Ruby.class");
        if (jrubyPropertiesUrl != null) {
            Pattern jarFile = Pattern.compile("jar:file:.*?([a-zA-Z0-9.\\-]+\\.jar)!/org/jruby/Ruby.class");
            Matcher jarMatcher = jarFile.matcher(jrubyPropertiesUrl.toString());
            jarMatcher.find();
            if (jarMatcher.matches()) {
                jrubyJarFile = jarMatcher.group(1);
            }
        }
        RbConfigLibrary.setConfig(context, CONFIG, "LIBRUBY", jrubyJarFile);
        RbConfigLibrary.setConfig(context, CONFIG, "LIBRUBY_SO", jrubyJarFile);
        RbConfigLibrary.setConfig(context, CONFIG, "LIBRUBY_SO", jrubyJarFile);
        RbConfigLibrary.setConfig(context, CONFIG, "LIBRUBY_ALIASES", jrubyJarFile);
        RbConfigLibrary.setConfig(context, CONFIG, "build", "java1.8");
        RbConfigLibrary.setConfig(context, CONFIG, "target", "java1.8");
        String shareDir = RbConfigLibrary.newFile(normalizedHome, "share").getPath();
        String includeDir = RbConfigLibrary.newFile(normalizedHome, "lib/ruby/include").getPath();
        String vendorDirGeneral = RbConfigLibrary.getVendorDirGeneral(runtime2);
        String siteDirGeneral = RbConfigLibrary.getSiteDirGeneral(runtime2);
        String rubySharedLibDir = RbConfigLibrary.getRubySharedLibDir(runtime2);
        String rubyLibDir = RbConfigLibrary.getRubyLibDir(runtime2);
        String archDir = RbConfigLibrary.getArchDir(runtime2);
        String vendorDir = RbConfigLibrary.getVendorDir(runtime2);
        String vendorLibDir = RbConfigLibrary.getVendorLibDir(runtime2);
        String vendorArchDir = RbConfigLibrary.getVendorArchDir(runtime2);
        String siteDir = RbConfigLibrary.getSiteDir(runtime2);
        String siteLibDir = RbConfigLibrary.getSiteLibDir(runtime2);
        String siteArchDir = RbConfigLibrary.getSiteArchDir(runtime2);
        String sysConfDir = RbConfigLibrary.getSysConfDir(runtime2);
        RbConfigLibrary.setConfig(context, CONFIG, "libdir", vendorDirGeneral);
        RbConfigLibrary.setConfig(context, CONFIG, "rubylibprefix", vendorDirGeneral + "/ruby");
        RbConfigLibrary.setConfig(context, CONFIG, "rubylibdir", rubyLibDir);
        RbConfigLibrary.setConfig(context, CONFIG, "rubysharedlibdir", rubySharedLibDir);
        if (!RbConfigLibrary.isSiteVendorSame(runtime2).booleanValue()) {
            RbConfigLibrary.setConfig(context, CONFIG, "vendordir", vendorDir);
            RbConfigLibrary.setConfig(context, CONFIG, "vendorlibdir", vendorLibDir);
            RbConfigLibrary.setConfig(context, CONFIG, "vendorarchdir", vendorArchDir);
        }
        RbConfigLibrary.setConfig(context, CONFIG, "sitedir", siteDir);
        RbConfigLibrary.setConfig(context, CONFIG, "sitelibdir", siteLibDir);
        RbConfigLibrary.setConfig(context, CONFIG, "sitearchdir", siteArchDir);
        RbConfigLibrary.setConfig(context, CONFIG, "sitearch", "java");
        RbConfigLibrary.setConfig(context, CONFIG, "archdir", archDir);
        RbConfigLibrary.setConfig(context, CONFIG, "topdir", archDir);
        RbConfigLibrary.setConfig(context, CONFIG, "includedir", includeDir);
        RbConfigLibrary.setConfig(context, CONFIG, "rubyhdrdir", includeDir);
        RbConfigLibrary.setConfig(context, CONFIG, "configure_args", "");
        RbConfigLibrary.setConfig(context, CONFIG, "datadir", shareDir);
        RbConfigLibrary.setConfig(context, CONFIG, "mandir", RbConfigLibrary.newFile(normalizedHome, "man").getPath());
        RbConfigLibrary.setConfig(context, CONFIG, "sysconfdir", sysConfDir);
        RbConfigLibrary.setConfig(context, CONFIG, "localstatedir", RbConfigLibrary.newFile(normalizedHome, "var").getPath());
        RbConfigLibrary.setConfig(context, CONFIG, "DLEXT", "jar");
        String rubygemsDir = RbConfigLibrary.getRubygemsDir(runtime2);
        if (rubygemsDir != null) {
            RbConfigLibrary.setConfig(context, CONFIG, "rubygemsdir", RbConfigLibrary.newFile(rubygemsDir).getPath());
        }
        if (org.jruby.platform.Platform.IS_WINDOWS) {
            RbConfigLibrary.setConfig(context, CONFIG, "EXEEXT", ".exe");
        } else {
            RbConfigLibrary.setConfig(context, CONFIG, "EXEEXT", "");
        }
        RbConfigLibrary.setConfig(context, CONFIG, "ridir", RbConfigLibrary.newFile(shareDir, "ri").getPath());
        String gemhome = SafePropertyAccessor.getProperty("jruby.gem.home");
        String gempath = SafePropertyAccessor.getProperty("jruby.gem.path");
        if (gemhome != null) {
            RbConfigLibrary.setConfig(context, CONFIG, "default_gem_home", gemhome);
        }
        if (gempath != null) {
            RbConfigLibrary.setConfig(context, CONFIG, "default_gem_path", gempath);
        }
        RbConfigLibrary.setConfig(context, CONFIG, "joda-time.version", "2.10.5");
        RbConfigLibrary.setConfig(context, CONFIG, "tzdata.version", "2019c");
        rbConfig.defineConstant("CONFIG", CONFIG);
        RubyHash mkmfHash = new RubyHash(runtime2, 64);
        RbConfigLibrary.setConfig(context, mkmfHash, "libdir", vendorDirGeneral);
        RbConfigLibrary.setConfig(context, mkmfHash, "arch", "java");
        RbConfigLibrary.setConfig(context, mkmfHash, "rubylibdir", rubyLibDir);
        RbConfigLibrary.setConfig(context, mkmfHash, "rubysharedlibdir", rubySharedLibDir);
        if (!RbConfigLibrary.isSiteVendorSame(runtime2).booleanValue()) {
            RbConfigLibrary.setConfig(context, mkmfHash, "vendordir", vendorDir);
            RbConfigLibrary.setConfig(context, mkmfHash, "vendorlibdir", vendorLibDir);
            RbConfigLibrary.setConfig(context, mkmfHash, "vendorarchdir", vendorArchDir);
        }
        RbConfigLibrary.setConfig(context, mkmfHash, "sitedir", siteDir);
        RbConfigLibrary.setConfig(context, mkmfHash, "sitelibdir", siteLibDir);
        RbConfigLibrary.setConfig(context, mkmfHash, "sitearchdir", siteArchDir);
        RbConfigLibrary.setConfig(context, mkmfHash, "sitearch", "java");
        RbConfigLibrary.setConfig(context, mkmfHash, "archdir", archDir);
        RbConfigLibrary.setConfig(context, mkmfHash, "topdir", archDir);
        RbConfigLibrary.setConfig(context, mkmfHash, "configure_args", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "datadir", RbConfigLibrary.newFile(normalizedHome, "share").getPath());
        RbConfigLibrary.setConfig(context, mkmfHash, "mandir", RbConfigLibrary.newFile(normalizedHome, "man").getPath());
        RbConfigLibrary.setConfig(context, mkmfHash, "sysconfdir", sysConfDir);
        RbConfigLibrary.setConfig(context, mkmfHash, "localstatedir", RbConfigLibrary.newFile(normalizedHome, "var").getPath());
        if (rubygemsDir != null) {
            RbConfigLibrary.setConfig(context, mkmfHash, "rubygemsdir", RbConfigLibrary.newFile(rubygemsDir).getPath());
        }
        RbConfigLibrary.setupMakefileConfig(context, mkmfHash);
        rbConfig.defineConstant("MAKEFILE_CONFIG", mkmfHash);
        runtime2.getLoadService().load("jruby/kernel/rbconfig.rb", false);
    }

    private static void setupMakefileConfig(ThreadContext context, RubyHash mkmfHash) {
        RubyHash envHash = (RubyHash)context.runtime.getObject().fetchConstant("ENV");
        String cc = RbConfigLibrary.getRubyEnv(envHash, "CC", "cc");
        String cpp = RbConfigLibrary.getRubyEnv(envHash, "CPP", "cc -E");
        String cxx = RbConfigLibrary.getRubyEnv(envHash, "CXX", "c++");
        String jflags = " -fno-omit-frame-pointer -fno-strict-aliasing ";
        String cflags = jflags + " -fexceptions $(cflags)";
        String cppflags = " $(DEFS) $(cppflags)";
        String cxxflags = cflags + " $(cxxflags)";
        String ldflags = "";
        String dldflags = "";
        String ldsharedflags = " -shared ";
        String archflags = " -m" + (IS_64_BIT ? "64" : "32");
        String hdr_dir = RbConfigLibrary.newFile(normalizedHome, "lib/native/include/").getPath();
        if (org.jruby.platform.Platform.IS_WINDOWS) {
            ldflags = ldflags + " -L" + RbConfigLibrary.newFile(normalizedHome, "lib/native/" + (IS_64_BIT ? "x86_64" : "i386") + "-Windows").getPath();
            ldsharedflags = ldsharedflags + " $(if $(filter-out -g -g0,$(debugflags)),,-s)";
            dldflags = "-Wl,--enable-auto-image-base,--enable-auto-import $(DEFFILE)";
            archflags = archflags + " -march=native -mtune=native";
            RbConfigLibrary.setConfig(context, mkmfHash, "DLEXT", "dll");
            RbConfigLibrary.setConfig(context, mkmfHash, "EXEEXT", ".exe");
        } else if (org.jruby.platform.Platform.IS_MAC) {
            ldsharedflags = " -dynamic -bundle -undefined dynamic_lookup ";
            cflags = " -DTARGET_RT_MAC_CFM=0 " + cflags;
            archflags = " -arch " + RbConfigLibrary.getArchitecture();
            cppflags = " -D_XOPEN_SOURCE -D_DARWIN_C_SOURCE " + cppflags;
            RbConfigLibrary.setConfig(context, mkmfHash, "DLEXT", "bundle");
            RbConfigLibrary.setConfig(context, mkmfHash, "EXEEXT", "");
        } else {
            RbConfigLibrary.setConfig(context, mkmfHash, "DLEXT", "so");
            RbConfigLibrary.setConfig(context, mkmfHash, "EXEEXT", "");
        }
        String libext = "a";
        String objext = "o";
        RbConfigLibrary.setConfig(context, mkmfHash, "configure_args", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "CCDLFLAGS", "-fPIC");
        RbConfigLibrary.setConfig(context, mkmfHash, "CFLAGS", cflags);
        RbConfigLibrary.setConfig(context, mkmfHash, "CPPFLAGS", cppflags);
        RbConfigLibrary.setConfig(context, mkmfHash, "CXXFLAGS", cxxflags);
        RbConfigLibrary.setConfig(context, mkmfHash, "ARCH_FLAG", archflags);
        RbConfigLibrary.setConfig(context, mkmfHash, "LDFLAGS", ldflags);
        RbConfigLibrary.setConfig(context, mkmfHash, "DLDFLAGS", dldflags);
        RbConfigLibrary.setConfig(context, mkmfHash, "DEFS", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "LIBEXT", libext);
        RbConfigLibrary.setConfig(context, mkmfHash, "OBJEXT", objext);
        RbConfigLibrary.setConfig(context, mkmfHash, "LIBRUBYARG_STATIC", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "LIBRUBYARG_SHARED", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "LIBS", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "DLDLIBS", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "ENABLED_SHARED", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "LIBRUBY", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "LIBRUBY_A", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "LIBRUBYARG", "");
        RbConfigLibrary.setConfig(context, mkmfHash, "prefix", " ");
        RbConfigLibrary.setConfig(context, mkmfHash, "ruby_install_name", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(context, mkmfHash, "LDSHARED", cc + ldsharedflags);
        RbConfigLibrary.setConfig(context, mkmfHash, "LDSHAREDXX", cxx + ldsharedflags);
        RbConfigLibrary.setConfig(context, mkmfHash, "RUBY_PLATFORM", RbConfigLibrary.getOSName());
        RbConfigLibrary.setConfig(context, mkmfHash, "RUBY_SO_NAME", "jruby");
        RbConfigLibrary.setConfig(context, mkmfHash, "CC", cc);
        RbConfigLibrary.setConfig(context, mkmfHash, "CPP", cpp);
        RbConfigLibrary.setConfig(context, mkmfHash, "CXX", cxx);
        RbConfigLibrary.setConfig(context, mkmfHash, "OUTFLAG", "-o ");
        RbConfigLibrary.setConfig(context, mkmfHash, "COUTFLAG", "-o ");
        RbConfigLibrary.setConfig(context, mkmfHash, "COMMON_HEADERS", "ruby.h");
        RbConfigLibrary.setConfig(context, mkmfHash, "PATH_SEPARATOR", ":");
        RbConfigLibrary.setConfig(context, mkmfHash, "INSTALL", "install -c ");
        RbConfigLibrary.setConfig(context, mkmfHash, "RM", "rm -f");
        RbConfigLibrary.setConfig(context, mkmfHash, "CP", "cp ");
        RbConfigLibrary.setConfig(context, mkmfHash, "MAKEDIRS", "mkdir -p ");
        RbConfigLibrary.setConfig(context, mkmfHash, "includedir", hdr_dir);
        RbConfigLibrary.setConfig(context, mkmfHash, "rubyhdrdir", hdr_dir);
        RbConfigLibrary.setConfig(context, mkmfHash, "archdir", hdr_dir);
        context.runtime.getObject().defineConstant("CROSS_COMPILING", context.nil);
    }

    private static void setConfig(ThreadContext context, RubyHash hash2, String key2, String value2) {
        Ruby runtime2 = context.runtime;
        hash2.fastASetCheckString(runtime2, runtime2.newString(key2), runtime2.newString(value2));
    }

    public static String jrubyScript() {
        return SafePropertyAccessor.getProperty("jruby.script", "jruby").replace('\\', '/');
    }

    public static String jrubyShell() {
        return SafePropertyAccessor.getProperty("jruby.shell", org.jruby.platform.Platform.IS_WINDOWS ? "cmd.exe" : "/bin/sh").replace('\\', '/');
    }

    private static String getRubyEnv(RubyHash envHash, String var, String default_value) {
        return (var = (String)envHash.get(var)) == null ? default_value : var;
    }

    private static File newFile(String path2) {
        return new NormalizedFile(path2);
    }

    private static File newFile(String parent, String child) {
        return new NormalizedFile(parent, child);
    }

    static {
        RUBY_OS_NAMES = new HashMap<String, String>(24, 1.0f);
        RUBY_OS_NAMES.put("Mac OS X", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Darwin", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Linux", RUBY_LINUX);
        RUBY_OS_NAMES.put("Windows 95", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 98", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Me", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 2000", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT (unknown)", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows XP", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 2003", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Vista", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 7", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Server 2008", RUBY_WIN32);
        RUBY_OS_NAMES.put("Solaris", RUBY_SOLARIS);
        RUBY_OS_NAMES.put("SunOS", RUBY_SOLARIS);
        RUBY_OS_NAMES.put("FreeBSD", RUBY_FREEBSD);
        RUBY_OS_NAMES.put("DragonFlyBSD", RUBY_DRAGONFLYBSD);
        RUBY_OS_NAMES.put("AIX", RUBY_AIX);
        IS_64_BIT = Platform.IS_64_BIT;
    }
}

