/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.TransportListener;

public abstract class AbstractTransportMapping<A extends Address>
implements TransportMapping<A> {
    protected List<TransportListener> transportListener = new ArrayList<TransportListener>(1);
    protected int maxInboundMessageSize = 65535;
    protected boolean asyncMsgProcessingSupported = true;

    @Override
    public abstract Class<? extends Address> getSupportedAddressClass();

    @Override
    public abstract void sendMessage(A var1, byte[] var2, TransportStateReference var3) throws IOException;

    @Override
    public synchronized void addTransportListener(TransportListener l) {
        if (!this.transportListener.contains(l)) {
            ArrayList<TransportListener> tlCopy = new ArrayList<TransportListener>(this.transportListener);
            tlCopy.add(l);
            this.transportListener = tlCopy;
        }
    }

    @Override
    public synchronized void removeTransportListener(TransportListener l) {
        if (this.transportListener != null && this.transportListener.contains(l)) {
            ArrayList<TransportListener> tlCopy = new ArrayList<TransportListener>(this.transportListener);
            tlCopy.remove(l);
            this.transportListener = tlCopy;
        }
    }

    protected void fireProcessMessage(Address address, ByteBuffer buf, TransportStateReference tmStateReference) {
        if (this.transportListener != null) {
            for (TransportListener aTransportListener : this.transportListener) {
                aTransportListener.processMessage(this, address, buf, tmStateReference);
            }
        }
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract void listen() throws IOException;

    @Override
    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public boolean isAsyncMsgProcessingSupported() {
        return this.asyncMsgProcessingSupported;
    }

    public void setAsyncMsgProcessingSupported(boolean asyncMsgProcessingSupported) {
        this.asyncMsgProcessingSupported = asyncMsgProcessingSupported;
    }
}

