/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.uaparser;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.logstash.uaparser.Client;
import org.logstash.uaparser.DeviceParser;
import org.logstash.uaparser.OS;
import org.logstash.uaparser.OSParser;
import org.logstash.uaparser.UserAgent;
import org.logstash.uaparser.UserAgentParser;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class Parser {
    private static final String REGEX_YAML_PATH = "/regexes.yaml";
    private UserAgentParser uaParser;
    private OSParser osParser;
    private DeviceParser deviceParser;

    public Parser() {
        this(Parser.class.getResourceAsStream(REGEX_YAML_PATH));
    }

    public Parser(InputStream regexYaml) {
        this.initialize(regexYaml);
    }

    public Client parse(String agentString) {
        return new Client(this.parseUserAgent(agentString), this.parseOS(agentString), this.deviceParser.parse(agentString));
    }

    public UserAgent parseUserAgent(String agentString) {
        return this.uaParser.parse(agentString);
    }

    public String parseDevice(String agentString) {
        return this.deviceParser.parse(agentString);
    }

    public OS parseOS(String agentString) {
        return this.osParser.parse(agentString);
    }

    private void initialize(InputStream regexYaml) {
        Yaml yaml = new Yaml(new SafeConstructor());
        Map regexConfig = (Map)yaml.load(regexYaml);
        List uaParserConfigs = (List)regexConfig.get("user_agent_parsers");
        if (uaParserConfigs == null) {
            throw new IllegalArgumentException("user_agent_parsers is missing from yaml");
        }
        this.uaParser = UserAgentParser.fromList(uaParserConfigs);
        List osParserConfigs = (List)regexConfig.get("os_parsers");
        if (osParserConfigs == null) {
            throw new IllegalArgumentException("os_parsers is missing from yaml");
        }
        this.osParser = OSParser.fromList(osParserConfigs);
        List deviceParserConfigs = (List)regexConfig.get("device_parsers");
        if (deviceParserConfigs == null) {
            throw new IllegalArgumentException("device_parsers is missing from yaml");
        }
        this.deviceParser = DeviceParser.fromList(deviceParserConfigs);
    }
}

