/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.ClientEntity;
import com.microsoft.azure.eventhubs.impl.SchedulerProvider;
import com.microsoft.azure.eventhubs.impl.Timer;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActiveClientTokenManager {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ActiveClientTokenManager.class);
    private final Object timerLock;
    private final Runnable sendTokenTask;
    private final ClientEntity clientEntity;
    private final Duration tokenRefreshInterval;
    private final SchedulerProvider schedulerProvider;
    private final Timer timerScheduler;
    private CompletableFuture timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveClientTokenManager(ClientEntity clientEntity, Runnable sendTokenAsync, Duration tokenRefreshInterval, SchedulerProvider schedulerProvider) {
        this.sendTokenTask = sendTokenAsync;
        this.clientEntity = clientEntity;
        this.tokenRefreshInterval = tokenRefreshInterval;
        this.timerLock = new Object();
        this.schedulerProvider = schedulerProvider;
        this.timerScheduler = new Timer(schedulerProvider);
        Object object = this.timerLock;
        synchronized (object) {
            this.timer = this.timerScheduler.schedule(new TimerCallback(), tokenRefreshInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.timerLock;
        synchronized (object) {
            this.timer.cancel(false);
        }
    }

    private class TimerCallback
    implements Runnable {
        private TimerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!ActiveClientTokenManager.this.clientEntity.getIsClosingOrClosed()) {
                ActiveClientTokenManager.this.sendTokenTask.run();
                Object object = ActiveClientTokenManager.this.timerLock;
                synchronized (object) {
                    ActiveClientTokenManager.this.timer = ActiveClientTokenManager.this.timerScheduler.schedule(new TimerCallback(), ActiveClientTokenManager.this.tokenRefreshInterval);
                }
            } else if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format(Locale.US, "clientEntity[%s] - closing ActiveClientLinkManager", ActiveClientTokenManager.this.clientEntity.getClientId()));
            }
        }
    }
}

