/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.puma;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManagerFactory;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class MiniSSL
extends RubyObject {
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new MiniSSL(ruby, rubyClass);
        }
    };
    private SSLEngine engine;
    private MiniSSLBuffer inboundNetData;
    private MiniSSLBuffer outboundAppData;
    private MiniSSLBuffer outboundNetData;

    public static void createMiniSSL(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Puma");
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("MiniSSL");
        rubyModule.defineClassUnder("SSLError", ruby.getClass("IOError"), ruby.getClass("IOError").getAllocator());
        RubyClass rubyClass = rubyModule2.defineClassUnder("Engine", ruby.getObject(), ALLOCATOR);
        rubyClass.defineAnnotatedMethods(MiniSSL.class);
    }

    public MiniSSL(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject server(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        return rubyClass.newInstance(threadContext, new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        String[] stringArray;
        IRubyObject iRubyObject2;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] cArray = iRubyObject.callMethod(threadContext, "keystore_pass").convertToString().asJavaString().toCharArray();
        String string = iRubyObject.callMethod(threadContext, "keystore").convertToString().asJavaString();
        keyStore.load(new FileInputStream(string), cArray);
        keyStore2.load(new FileInputStream(string), cArray);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, cArray);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore2);
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        this.engine = sSLContext.createSSLEngine();
        String[] stringArray2 = iRubyObject.callMethod(threadContext, "no_tlsv1").isTrue() ? new String[]{"TLSv1.1", "TLSv1.2"} : new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        if (iRubyObject.callMethod(threadContext, "no_tlsv1_1").isTrue()) {
            stringArray2 = new String[]{"TLSv1.2"};
        }
        this.engine.setEnabledProtocols(stringArray2);
        this.engine.setUseClientMode(false);
        long l = iRubyObject.callMethod(threadContext, "verify_mode").convertToInteger().getLongValue();
        if ((l & 1L) != 0L) {
            this.engine.setWantClientAuth(true);
        }
        if ((l & 2L) != 0L) {
            this.engine.setNeedClientAuth(true);
        }
        if (!(iRubyObject2 = iRubyObject.callMethod(threadContext, "ssl_cipher_list")).isNil()) {
            stringArray = iRubyObject2.convertToString().asJavaString().split(",");
            this.engine.setEnabledCipherSuites(stringArray);
        }
        stringArray = this.engine.getSession();
        this.inboundNetData = new MiniSSLBuffer(stringArray.getPacketBufferSize());
        this.outboundAppData = new MiniSSLBuffer(stringArray.getApplicationBufferSize());
        this.outboundAppData.flip();
        this.outboundNetData = new MiniSSLBuffer(stringArray.getPacketBufferSize());
        return this;
    }

    @JRubyMethod
    public IRubyObject inject(IRubyObject iRubyObject) {
        try {
            byte[] byArray = iRubyObject.convertToString().getBytes();
            this.inboundNetData.put(byArray);
            return this;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    private SSLEngineResult doOp(SSLOperation sSLOperation, MiniSSLBuffer miniSSLBuffer, MiniSSLBuffer miniSSLBuffer2) throws SSLException {
        SSLEngineResult sSLEngineResult = null;
        boolean bl = true;
        block8: while (bl) {
            switch (sSLOperation) {
                case WRAP: {
                    sSLEngineResult = this.engine.wrap(miniSSLBuffer.getRawBuffer(), miniSSLBuffer2.getRawBuffer());
                    break;
                }
                case UNWRAP: {
                    sSLEngineResult = this.engine.unwrap(miniSSLBuffer.getRawBuffer(), miniSSLBuffer2.getRawBuffer());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown SSLOperation: " + (Object)((Object)sSLOperation));
                }
            }
            switch (sSLEngineResult.getStatus()) {
                case BUFFER_OVERFLOW: {
                    int n = Math.max(this.engine.getSession().getPacketBufferSize(), this.engine.getSession().getApplicationBufferSize());
                    miniSSLBuffer2.resize(n + miniSSLBuffer2.position());
                    bl = true;
                    continue block8;
                }
                case BUFFER_UNDERFLOW: {
                    bl = false;
                    continue block8;
                }
            }
            bl = false;
        }
        if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = this.engine.getDelegatedTask()) != null) {
                runnable.run();
            }
        }
        return sSLEngineResult;
    }

    @JRubyMethod
    public IRubyObject read() throws Exception {
        try {
            Object object;
            this.inboundNetData.flip();
            if (!this.inboundNetData.hasRemaining()) {
                return this.getRuntime().getNil();
            }
            MiniSSLBuffer miniSSLBuffer = new MiniSSLBuffer(this.engine.getSession().getApplicationBufferSize());
            this.doOp(SSLOperation.UNWRAP, this.inboundNetData, miniSSLBuffer);
            SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
            boolean bl = false;
            while (!bl) {
                switch (handshakeStatus) {
                    case NEED_WRAP: {
                        this.doOp(SSLOperation.WRAP, miniSSLBuffer, this.outboundNetData);
                        break;
                    }
                    case NEED_UNWRAP: {
                        object = this.doOp(SSLOperation.UNWRAP, this.inboundNetData, miniSSLBuffer);
                        if (((SSLEngineResult)object).getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                handshakeStatus = this.engine.getHandshakeStatus();
            }
            if (this.inboundNetData.hasRemaining()) {
                this.inboundNetData.compact();
            } else {
                this.inboundNetData.clear();
            }
            object = miniSSLBuffer.asByteList();
            if (object == null) {
                return this.getRuntime().getNil();
            }
            RubyString rubyString = this.getRuntime().newString("");
            rubyString.setValue((ByteList)object);
            return rubyString;
        }
        catch (Exception exception) {
            throw this.getRuntime().newEOFError(exception.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject write(IRubyObject iRubyObject) {
        try {
            byte[] byArray = iRubyObject.convertToString().getBytes();
            this.outboundAppData = new MiniSSLBuffer(byArray);
            return this.getRuntime().newFixnum(byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    @JRubyMethod
    public IRubyObject extract() throws SSLException {
        try {
            ByteList byteList = this.outboundNetData.asByteList();
            if (byteList != null) {
                RubyString rubyString = this.getRuntime().newString("");
                rubyString.setValue(byteList);
                return rubyString;
            }
            if (!this.outboundAppData.hasRemaining()) {
                return this.getRuntime().getNil();
            }
            this.outboundNetData.clear();
            this.doOp(SSLOperation.WRAP, this.outboundAppData, this.outboundNetData);
            byteList = this.outboundNetData.asByteList();
            if (byteList == null) {
                return this.getRuntime().getNil();
            }
            RubyString rubyString = this.getRuntime().newString("");
            rubyString.setValue(byteList);
            return rubyString;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    @JRubyMethod
    public IRubyObject peercert() throws CertificateEncodingException {
        try {
            return JavaEmbedUtils.javaToRuby((Ruby)this.getRuntime(), (Object)this.engine.getSession().getPeerCertificates()[0].getEncoded());
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return this.getRuntime().getNil();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SSLOperation {
        WRAP,
        UNWRAP;

    }

    private static class MiniSSLBuffer {
        ByteBuffer buffer;

        private MiniSSLBuffer(int n) {
            this.buffer = ByteBuffer.allocate(n);
        }

        private MiniSSLBuffer(byte[] byArray) {
            this.buffer = ByteBuffer.wrap(byArray);
        }

        public void clear() {
            this.buffer.clear();
        }

        public void compact() {
            this.buffer.compact();
        }

        public void flip() {
            ((Buffer)this.buffer).flip();
        }

        public boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        public int position() {
            return this.buffer.position();
        }

        public ByteBuffer getRawBuffer() {
            return this.buffer;
        }

        public void put(byte[] byArray) {
            if (this.buffer.remaining() < byArray.length) {
                this.resize(this.buffer.limit() + byArray.length);
            }
            this.buffer.put(byArray);
        }

        public void resize(int n) {
            if (n > this.buffer.capacity()) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                this.flip();
                byteBuffer.put(this.buffer);
                this.buffer = byteBuffer;
            } else {
                this.buffer.limit(n);
            }
        }

        public ByteList asByteList() {
            this.flip();
            if (!this.buffer.hasRemaining()) {
                this.buffer.clear();
                return null;
            }
            byte[] byArray = new byte[this.buffer.limit()];
            this.buffer.get(byArray);
            this.buffer.clear();
            return new ByteList(byArray);
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

