/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyBasicObject;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.BimorphicCallSite;
import org.jruby.runtime.callsite.CacheEntry;

public class DivCallSite
extends BimorphicCallSite {
    public DivCallSite() {
        super("/");
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, long arg1) {
        CacheEntry cache;
        if (self2 instanceof RubyFixnum) {
            CacheEntry cache2 = this.cache;
            if (cache2 instanceof FixnumEntry && cache2.typeOk(RubyBasicObject.getMetaClass(self2))) {
                return ((RubyFixnum)self2).op_div(context, arg1);
            }
        } else if (self2 instanceof RubyFloat && (cache = this.secondaryCache) instanceof FloatEntry && cache.typeOk(RubyBasicObject.getMetaClass(self2))) {
            return ((RubyFloat)self2).op_div(context, arg1);
        }
        return super.call(context, caller2, self2, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1) {
        CacheEntry cache;
        if (self2 instanceof RubyFixnum) {
            CacheEntry cache2 = this.cache;
            if (cache2 instanceof FixnumEntry && cache2.typeOk(RubyBasicObject.getMetaClass(self2))) {
                return ((RubyFixnum)self2).op_div(context, arg1);
            }
        } else if (self2 instanceof RubyFloat && (cache = this.secondaryCache) instanceof FloatEntry && cache.typeOk(RubyBasicObject.getMetaClass(self2))) {
            return ((RubyFloat)self2).op_div(context, arg1);
        }
        return super.call(context, caller2, self2, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, double arg1) {
        CacheEntry cache;
        if (self2 instanceof RubyFloat && (cache = this.secondaryCache) instanceof FloatEntry && cache.typeOk(RubyBasicObject.getMetaClass(self2))) {
            return ((RubyFloat)self2).op_div(context, arg1);
        }
        return super.call(context, caller2, self2, arg1);
    }

    @Override
    protected CacheEntry setCache(CacheEntry entry, IRubyObject self2) {
        if (self2 instanceof RubyFixnum && entry.method.isBuiltin()) {
            this.cache = new FixnumEntry(entry);
            return this.cache;
        }
        this.cache = entry;
        return this.cache;
    }

    @Override
    protected CacheEntry setSecondaryCache(CacheEntry entry, IRubyObject self2) {
        if (self2 instanceof RubyFloat && entry.method.isBuiltin()) {
            this.secondaryCache = new FloatEntry(entry);
            return this.secondaryCache;
        }
        this.secondaryCache = entry;
        return this.secondaryCache;
    }

    @Override
    public boolean isBuiltin(IRubyObject self2) {
        CacheEntry cache;
        if (self2 instanceof RubyFixnum && (cache = this.cache).typeOk(RubyBasicObject.getMetaClass(self2))) {
            return cache instanceof FixnumEntry;
        }
        return super.isBuiltin(self2);
    }

    @Override
    public boolean isSecondaryBuiltin(IRubyObject self2) {
        CacheEntry cache;
        if (self2 instanceof RubyFloat && (cache = this.secondaryCache).typeOk(RubyBasicObject.getMetaClass(self2))) {
            return cache instanceof FloatEntry;
        }
        return super.isSecondaryBuiltin(self2);
    }

    private static class FloatEntry
    extends CacheEntry {
        FloatEntry(CacheEntry entry) {
            super(entry.method, entry.sourceModule, entry.token);
        }
    }

    private static class FixnumEntry
    extends CacheEntry {
        FixnumEntry(CacheEntry entry) {
            super(entry.method, entry.sourceModule, entry.token);
        }
    }
}

