/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.context;

import com.codahale.metrics.Timer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.metrics.MetricsSupport;
import org.opensaml.messaging.context.BaseContext;

public class MetricContext
extends BaseContext {
    @Nonnull
    @NonnullElements
    private Multimap<String, Pair<String, String>> timerMap = ArrayListMultimap.create();
    @Nonnull
    @NonnullElements
    private Multimap<String, Timer.Context> timerContextMap = ArrayListMultimap.create();
    @Nonnull
    @NonnullElements
    private Map<String, String> counterMap = new HashMap<String, String>();

    @Nonnull
    public MetricContext addTimer(@Nonnull @NotEmpty String timerName, @Nonnull @NotEmpty String startId, @Nonnull @NotEmpty String stopId) {
        String key = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)startId), (String)"Starting object ID cannot be null or empty");
        String stop = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)stopId), (String)"Stop object ID cannot be null or empty");
        String name = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)timerName), (String)"Timer name cannot be null or empty");
        this.timerMap.put((Object)key, (Object)new Pair((Object)name, (Object)stop));
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Collection<Pair<String, String>> getTimerMappings(@Nonnull @NotEmpty String objectId) {
        return this.timerMap.get((Object)objectId);
    }

    @Nonnull
    public MetricContext addCounter(@Nonnull @NotEmpty String counterName, @Nonnull @NotEmpty String objectId) {
        String key = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)objectId), (String)"Starting object ID cannot be null or empty");
        String name = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)counterName), (String)"Counter name cannot be null or empty");
        this.counterMap.put(key, name);
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, String> getCounterMappings() {
        return this.counterMap;
    }

    public void start(@Nonnull @NotEmpty String objectId) {
        for (Pair timer : this.timerMap.get((Object)objectId)) {
            if (timer == null) continue;
            this.timerContextMap.put(timer.getSecond(), (Object)MetricsSupport.getMetricRegistry().timer((String)timer.getFirst()).time());
        }
    }

    public void stop(@Nonnull @NotEmpty String objectId) {
        Iterator iter = this.timerContextMap.get((Object)objectId).iterator();
        while (iter.hasNext()) {
            Timer.Context tc = (Timer.Context)iter.next();
            if (tc == null) continue;
            tc.stop();
            iter.remove();
        }
    }

    public void inc(@Nonnull @NotEmpty String objectId) {
        String name = this.counterMap.get(objectId);
        if (name != null) {
            MetricsSupport.getMetricRegistry().counter(name).inc();
        }
    }

    public void dec(@Nonnull @NotEmpty String objectId) {
        String name = this.counterMap.get(objectId);
        if (name != null) {
            MetricsSupport.getMetricRegistry().counter(name).dec();
        }
    }
}

