/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import java.util.HashSet;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.Attachments;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.ee.naming.JavaNamespaceSetup;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Values;

public class ModuleContextProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName appContextServiceName = ContextNames.contextServiceNameOfApplication((String)moduleDescription.getApplicationName());
        ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
        NamingStoreService contextService = new NamingStoreService(true);
        serviceTarget.addService(moduleContextServiceName, (Service)contextService).install();
        ServiceName moduleNameServiceName = moduleContextServiceName.append(new String[]{"ModuleName"});
        BinderService moduleNameBinder = new BinderService("ModuleName");
        moduleNameBinder.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory(Values.immediateValue((Object)moduleDescription.getModuleName())));
        serviceTarget.addService(moduleNameServiceName, (Service)moduleNameBinder).addDependency(moduleContextServiceName, ServiceBasedNamingStore.class, (Injector)moduleNameBinder.getNamingStoreInjector()).install();
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES, (Object)moduleNameServiceName);
        deploymentUnit.putAttachment(Attachments.MODULE_CONTEXT_CONFIG, (Object)moduleContextServiceName);
        InjectedEENamespaceContextSelector selector = new InjectedEENamespaceContextSelector();
        phaseContext.requires(appContextServiceName, selector.getAppContextSupplier());
        phaseContext.requires(moduleContextServiceName, selector.getModuleContextSupplier());
        phaseContext.requires(moduleContextServiceName, selector.getCompContextSupplier());
        phaseContext.requires(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, selector.getJbossContextSupplier());
        phaseContext.requires(ContextNames.EXPORTED_CONTEXT_SERVICE_NAME, selector.getExportedContextSupplier());
        phaseContext.requires(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, selector.getGlobalContextSupplier());
        moduleDescription.setNamespaceContextSelector(selector);
        HashSet<ServiceName> serviceNames = new HashSet<ServiceName>();
        serviceNames.add(appContextServiceName);
        serviceNames.add(moduleContextServiceName);
        serviceNames.add(ContextNames.JBOSS_CONTEXT_SERVICE_NAME);
        serviceNames.add(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME);
        JavaNamespaceSetup setupAction = new JavaNamespaceSetup(selector, deploymentUnit.getServiceName());
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.SETUP_ACTIONS, (Object)setupAction);
        deploymentUnit.addToAttachmentList(org.jboss.as.ee.component.Attachments.WEB_SETUP_ACTIONS, (Object)setupAction);
        deploymentUnit.putAttachment(Attachments.JAVA_NAMESPACE_SETUP_ACTION, (Object)setupAction);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.JAVA_NAMESPACE_SETUP_ACTION);
        deploymentUnit.getAttachmentList(org.jboss.as.ee.component.Attachments.WEB_SETUP_ACTIONS).removeIf(setupAction -> setupAction instanceof JavaNamespaceSetup);
        deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.SETUP_ACTIONS).removeIf(setupAction -> setupAction instanceof JavaNamespaceSetup);
        deploymentUnit.removeAttachment(Attachments.MODULE_CONTEXT_CONFIG);
    }
}

