/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import io.smallrye.health.Response;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

class ResponseBuilder
extends HealthCheckResponseBuilder {
    private String name;
    private HealthCheckResponse.State state = HealthCheckResponse.State.DOWN;
    private Map<String, Object> data = new HashMap<String, Object>();

    ResponseBuilder() {
    }

    public HealthCheckResponseBuilder name(String name) {
        this.name = name;
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, String value) {
        this.data.put(key, value);
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, long value) {
        this.data.put(key, value);
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, boolean value) {
        this.data.put(key, value);
        return this;
    }

    public HealthCheckResponseBuilder up() {
        this.state = HealthCheckResponse.State.UP;
        return this;
    }

    public HealthCheckResponseBuilder down() {
        this.state = HealthCheckResponse.State.DOWN;
        return this;
    }

    public HealthCheckResponseBuilder state(boolean up) {
        if (up) {
            return this.up();
        }
        return this.down();
    }

    public HealthCheckResponse build() {
        if (null == this.name || this.name.trim().length() == 0) {
            throw new IllegalArgumentException("Health Check contains an invalid name. Can not be null or empty.");
        }
        return new Response(this.name, this.state, this.data.isEmpty() ? null : this.data);
    }
}

