/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.jbossallxml;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParserDescription;

public class JBossAllXmlParserRegisteringProcessor<T>
implements DeploymentUnitProcessor {
    private final List<? extends JBossAllXMLParserDescription<?>> descriptions;

    public JBossAllXmlParserRegisteringProcessor(QName rootElement, AttachmentKey<T> attachmentKey, JBossAllXMLParser<T> parser) {
        this.descriptions = Collections.singletonList(new JBossAllXMLParserDescription<T>(attachmentKey, parser, rootElement));
    }

    private JBossAllXmlParserRegisteringProcessor(List<? extends JBossAllXMLParserDescription<?>> descriptions) {
        this.descriptions = descriptions;
    }

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        for (JBossAllXMLParserDescription<?> description : this.descriptions) {
            phaseContext.getDeploymentUnit().addToAttachmentList(JBossAllXMLParserDescription.ATTACHMENT_KEY, description);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
        unit.removeAttachment(JBossAllXMLParserDescription.ATTACHMENT_KEY);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<JBossAllXMLParserDescription<?>> descriptions = new LinkedList();

        private Builder() {
        }

        public <T> Builder addParser(QName rootElement, AttachmentKey<T> attachmentKey, JBossAllXMLParser<T> parser) {
            this.descriptions.add(new JBossAllXMLParserDescription<T>(attachmentKey, parser, rootElement));
            return this;
        }

        public JBossAllXmlParserRegisteringProcessor<Object> build() {
            return new JBossAllXmlParserRegisteringProcessor<Object>(this.descriptions);
        }
    }
}

