/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.Collection;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.jmx.AbstractJmxRegistration;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SurvivesRestarts
public class CacheJmxRegistration
extends AbstractJmxRegistration {
    private static final Log log = LogFactory.getLog(CacheJmxRegistration.class);
    public static final String CACHE_JMX_GROUP = "type=Cache";
    @Inject
    private Configuration cacheConfiguration;
    @Inject
    public CacheManagerJmxRegistration globalJmxRegistration;
    @ComponentName(value="cacheName")
    @Inject
    private String cacheName;
    private Collection<ResourceDMBean> nonCacheDMBeans;
    private boolean needToUnregister = false;
    private volatile boolean unregisterCacheMBean;

    @Start(priority=14)
    public void start() {
        this.initMBeanServer(this.globalConfig);
        if (this.mBeanServer != null) {
            Collection<ComponentRef<?>> components = this.basicComponentRegistry.getRegisteredComponents();
            Collection<ResourceDMBean> resourceDMBeans = this.getResourceDMBeansFromComponents(components);
            this.nonCacheDMBeans = this.getNonCacheComponents(resourceDMBeans);
            this.registrar.registerMBeans(resourceDMBeans);
            this.needToUnregister = true;
            log.mbeansSuccessfullyRegistered();
        }
    }

    @Stop
    public void stop() {
        if (this.needToUnregister) {
            try {
                this.unregisterMBeans(this.nonCacheDMBeans);
                this.needToUnregister = false;
            }
            catch (Exception e) {
                log.problemsUnregisteringMBeans(e);
            }
        }
        if (this.unregisterCacheMBean) {
            this.globalJmxRegistration.unregisterCacheMBean(this.cacheName, this.cacheConfiguration.clustering().cacheModeString());
        }
    }

    public void setUnregisterCacheMBean(boolean unregisterCacheMBean) {
        this.unregisterCacheMBean = unregisterCacheMBean;
    }

    @Override
    protected ComponentsJmxRegistration buildRegistrar() {
        String groupName = "type=Cache," + this.globalJmxRegistration.getCacheJmxName(this.cacheName, this.cacheConfiguration.clustering().cacheModeString()) + ",manager=" + ObjectName.quote(this.globalConfig.globalJmxStatistics().cacheManagerName());
        ComponentsJmxRegistration registrar = new ComponentsJmxRegistration(this.mBeanServer, groupName);
        this.updateDomain(registrar, this.mBeanServer, groupName, this.globalJmxRegistration);
        return registrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDomain(ComponentsJmxRegistration registrar, MBeanServer mBeanServer, String groupName, CacheManagerJmxRegistration globalJmxRegistration) {
        if (!this.globalConfig.globalJmxStatistics().enabled() && this.jmxDomain == null) {
            String tmpJmxDomain = JmxUtil.buildJmxDomain((String)this.globalConfig.globalJmxStatistics().domain(), (MBeanServer)mBeanServer, (String)groupName);
            CacheManagerJmxRegistration cacheManagerJmxRegistration = globalJmxRegistration;
            synchronized (cacheManagerJmxRegistration) {
                if (globalJmxRegistration.jmxDomain == null) {
                    if (!tmpJmxDomain.equals(this.globalConfig.globalJmxStatistics().domain()) && !this.globalConfig.globalJmxStatistics().allowDuplicateDomains()) {
                        throw log.jmxMBeanAlreadyRegistered(tmpJmxDomain, this.globalConfig.globalJmxStatistics().domain());
                    }
                    globalJmxRegistration.jmxDomain = tmpJmxDomain;
                }
                this.jmxDomain = globalJmxRegistration.jmxDomain;
            }
        } else {
            this.jmxDomain = globalJmxRegistration.jmxDomain == null ? this.globalConfig.globalJmxStatistics().domain() : globalJmxRegistration.jmxDomain;
        }
        registrar.setJmxDomain(this.jmxDomain);
    }

    protected Collection<ResourceDMBean> getNonCacheComponents(Collection<ResourceDMBean> components) {
        ArrayList<ResourceDMBean> componentsExceptCache = new ArrayList<ResourceDMBean>(64);
        for (ResourceDMBean component : components) {
            if ("Cache".equals(component.getObjectName())) continue;
            componentsExceptCache.add(component);
        }
        return componentsExceptCache;
    }
}

