/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;
import org.infinispan.remoting.transport.BackupResponse;

public class OptimisticBackupInterceptor
extends BaseBackupInterceptor {
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return this.invokeNext(ctx, command);
        }
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        BackupResponse backupResponse = this.backupSender.backupCommit(command);
        return this.processBackupResponse(ctx, command, backupResponse);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.shouldRollbackRemoteTxCommand(ctx)) {
            return this.invokeNext(ctx, command);
        }
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        BackupResponse backupResponse = this.backupSender.backupRollback(command);
        return this.processBackupResponse(ctx, command, backupResponse);
    }

    private boolean shouldRollbackRemoteTxCommand(TxInvocationContext ctx) {
        return this.shouldInvokeRemoteTxCommand(ctx) && this.hasBeenPrepared((LocalTxInvocationContext)ctx);
    }

    private boolean hasBeenPrepared(LocalTxInvocationContext ctx) {
        return !ctx.getRemoteLocksAcquired().isEmpty();
    }
}

