/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.globalstate.impl.GlobalConfigurationManagerImpl;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

@Listener(observation=Listener.Observation.POST)
public class GlobalConfigurationStateListener {
    private final GlobalConfigurationManagerImpl gcm;

    GlobalConfigurationStateListener(GlobalConfigurationManagerImpl gcm) {
        this.gcm = gcm;
    }

    @CacheEntryCreated
    public void createCache(CacheEntryCreatedEvent<ScopedState, CacheState> event) {
        String cacheName = ((ScopedState)event.getKey()).getName();
        CacheState state = (CacheState)event.getCache().get(event.getKey());
        this.gcm.createCacheLocally(cacheName, state);
    }

    @CacheEntryRemoved
    public void removeCache(CacheEntryRemovedEvent<ScopedState, CacheState> event) {
        String cacheName = ((ScopedState)event.getKey()).getName();
        this.gcm.removeCacheLocally(cacheName, event.getOldValue());
    }
}

