/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import javax.ws.rs.core.CacheControl;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.Config;
import org.keycloak.common.util.Resteasy;

public class CacheControlUtil {
    public static void noBackButtonCacheControlHeader() {
        HttpResponse response = Resteasy.getContextData(HttpResponse.class);
        response.getOutputHeaders().putSingle((Object)"Cache-Control", (Object)"no-store, must-revalidate, max-age=0");
    }

    public static CacheControl getDefaultCacheControl() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(false);
        Integer maxAge = Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge");
        if (maxAge != null && maxAge > 0) {
            cacheControl.setMaxAge(maxAge.intValue());
        } else {
            cacheControl.setNoCache(true);
        }
        return cacheControl;
    }

    public static CacheControl noCache() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMustRevalidate(true);
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return cacheControl;
    }
}

